"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudwatch = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudwatch');
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metricA = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') },
    period: cdk.Duration.seconds(10),
    label: 'Visible Messages'
});
const metricB = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesNotVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') },
    period: cdk.Duration.seconds(30),
    label: 'NotVisible Messages'
});
const sumExpression = new cloudwatch.MathExpression({
    expression: 'm1+m2',
    usingMetrics: {
        m1: metricA,
        m2: metricB
    },
    label: 'Total Messages',
    period: cdk.Duration.minutes(1)
});
const alarm = sumExpression.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyMathExpressionDashboardName'
});
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Total messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More total messages in queue with alarm annotation',
    left: [sumExpression],
    right: [metricA, metricB],
    leftAnnotations: [alarm.toAnnotation()]
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current total messages in queue',
    metrics: [sumExpression]
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubWF0aC1hbGFybS1hbmQtZGFzaGJvYXJkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubWF0aC1hbGFybS1hbmQtZGFzaGJvYXJkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwyRkFBMkY7QUFDM0YsRUFBRTtBQUNGLG9HQUFvRztBQUNwRyw4RkFBOEY7QUFDOUYsbUJBQW1COztBQUVuQixxQ0FBcUM7QUFDckMscUNBQXFDO0FBRXJDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUV2RCxNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxpQkFBaUIsRUFBRSxDQUFDLENBQUM7QUFFL0UsTUFBTSxPQUFPLEdBQUcsSUFBSSxVQUFVLENBQUMsTUFBTSxDQUFDO0lBQ3BDLFNBQVMsRUFBRSxTQUFTO0lBQ3BCLFVBQVUsRUFBRSxvQ0FBb0M7SUFDaEQsVUFBVSxFQUFFLEVBQUUsU0FBUyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLEVBQUU7SUFDcEQsTUFBTSxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztJQUNoQyxLQUFLLEVBQUUsa0JBQWtCO0NBQzFCLENBQUMsQ0FBQztBQUVILE1BQU0sT0FBTyxHQUFHLElBQUksVUFBVSxDQUFDLE1BQU0sQ0FBQztJQUNwQyxTQUFTLEVBQUUsU0FBUztJQUNwQixVQUFVLEVBQUUsdUNBQXVDO0lBQ25ELFVBQVUsRUFBRSxFQUFFLFNBQVMsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxFQUFFO0lBQ3BELE1BQU0sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7SUFDaEMsS0FBSyxFQUFFLHFCQUFxQjtDQUM3QixDQUFDLENBQUM7QUFFSCxNQUFNLGFBQWEsR0FBRyxJQUFJLFVBQVUsQ0FBQyxjQUFjLENBQUM7SUFDbEQsVUFBVSxFQUFFLE9BQU87SUFDbkIsWUFBWSxFQUFFO1FBQ1osRUFBRSxFQUFFLE9BQU87UUFDWCxFQUFFLEVBQUUsT0FBTztLQUNaO0lBQ0QsS0FBSyxFQUFFLGdCQUFnQjtJQUN2QixNQUFNLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0NBQ2hDLENBQUMsQ0FBQztBQUVILE1BQU0sS0FBSyxHQUFHLGFBQWEsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRTtJQUN0RCxTQUFTLEVBQUUsR0FBRztJQUNkLGlCQUFpQixFQUFFLENBQUM7Q0FDckIsQ0FBQyxDQUFDO0FBRUgsTUFBTSxTQUFTLEdBQUcsSUFBSSxVQUFVLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7SUFDeEQsYUFBYSxFQUFFLCtCQUErQjtDQUMvQyxDQUFDLENBQUM7QUFDSCxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksVUFBVSxDQUFDLFdBQVcsQ0FBQztJQUM5QyxLQUFLLEVBQUUseUJBQXlCO0lBQ2hDLEtBQUs7Q0FDTixDQUFDLENBQUMsQ0FBQztBQUVKLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxVQUFVLENBQUMsV0FBVyxDQUFDO0lBQzlDLEtBQUssRUFBRSxvREFBb0Q7SUFDM0QsSUFBSSxFQUFFLENBQUMsYUFBYSxDQUFDO0lBQ3JCLEtBQUssRUFBRSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUM7SUFDekIsZUFBZSxFQUFFLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxDQUFDO0NBQ3hDLENBQUMsQ0FBQyxDQUFDO0FBRUosU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztJQUNwRCxLQUFLLEVBQUUsaUNBQWlDO0lBQ3hDLE9BQU8sRUFBRSxDQUFDLGFBQWEsQ0FBQztDQUN6QixDQUFDLENBQUMsQ0FBQztBQUVKLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIEludGVncmF0aW9uIHRlc3QgdG8gZGVwbG95IHNvbWUgcmVzb3VyY2VzLCBjcmVhdGUgYW4gYWxhcm0gb24gaXQgYW5kIGNyZWF0ZSBhIGRhc2hib2FyZC5cbi8vXG4vLyBCZWNhdXNlIGxpdGVyYWxseSBldmVyeSBvdGhlciBsaWJyYXJ5IGlzIGdvaW5nIHRvIGRlcGVuZCBvbiBAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCwgd2UgZHJvcCBkb3duXG4vLyB0byB0aGUgdmVyeSBsb3dlc3QgbGV2ZWwgdG8gY3JlYXRlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlcyBieSBoYW5kLCB3aXRob3V0IGV2ZW4gZ2VuZXJhdGVkXG4vLyBsaWJyYXJ5IHN1cHBvcnQuXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstY2xvdWR3YXRjaCcpO1xuXG5jb25zdCBxdWV1ZSA9IG5ldyBjZGsuQ2ZuUmVzb3VyY2Uoc3RhY2ssICdxdWV1ZScsIHsgdHlwZTogJ0FXUzo6U1FTOjpRdWV1ZScgfSk7XG5cbmNvbnN0IG1ldHJpY0EgPSBuZXcgY2xvdWR3YXRjaC5NZXRyaWMoe1xuICBuYW1lc3BhY2U6ICdBV1MvU1FTJyxcbiAgbWV0cmljTmFtZTogJ0FwcHJveGltYXRlTnVtYmVyT2ZNZXNzYWdlc1Zpc2libGUnLFxuICBkaW1lbnNpb25zOiB7IFF1ZXVlTmFtZTogcXVldWUuZ2V0QXR0KCdRdWV1ZU5hbWUnKSB9LFxuICBwZXJpb2Q6IGNkay5EdXJhdGlvbi5zZWNvbmRzKDEwKSxcbiAgbGFiZWw6ICdWaXNpYmxlIE1lc3NhZ2VzJ1xufSk7XG5cbmNvbnN0IG1ldHJpY0IgPSBuZXcgY2xvdWR3YXRjaC5NZXRyaWMoe1xuICBuYW1lc3BhY2U6ICdBV1MvU1FTJyxcbiAgbWV0cmljTmFtZTogJ0FwcHJveGltYXRlTnVtYmVyT2ZNZXNzYWdlc05vdFZpc2libGUnLFxuICBkaW1lbnNpb25zOiB7IFF1ZXVlTmFtZTogcXVldWUuZ2V0QXR0KCdRdWV1ZU5hbWUnKSB9LFxuICBwZXJpb2Q6IGNkay5EdXJhdGlvbi5zZWNvbmRzKDMwKSxcbiAgbGFiZWw6ICdOb3RWaXNpYmxlIE1lc3NhZ2VzJ1xufSk7XG5cbmNvbnN0IHN1bUV4cHJlc3Npb24gPSBuZXcgY2xvdWR3YXRjaC5NYXRoRXhwcmVzc2lvbih7XG4gIGV4cHJlc3Npb246ICdtMSttMicsXG4gIHVzaW5nTWV0cmljczoge1xuICAgIG0xOiBtZXRyaWNBLFxuICAgIG0yOiBtZXRyaWNCXG4gIH0sXG4gIGxhYmVsOiAnVG90YWwgTWVzc2FnZXMnLFxuICBwZXJpb2Q6IGNkay5EdXJhdGlvbi5taW51dGVzKDEpXG59KTtcblxuY29uc3QgYWxhcm0gPSBzdW1FeHByZXNzaW9uLmNyZWF0ZUFsYXJtKHN0YWNrLCAnQWxhcm0nLCB7XG4gIHRocmVzaG9sZDogMTAwLFxuICBldmFsdWF0aW9uUGVyaW9kczogMyxcbn0pO1xuXG5jb25zdCBkYXNoYm9hcmQgPSBuZXcgY2xvdWR3YXRjaC5EYXNoYm9hcmQoc3RhY2ssICdEYXNoJywge1xuICBkYXNoYm9hcmROYW1lOiAnTXlNYXRoRXhwcmVzc2lvbkRhc2hib2FyZE5hbWUnXG59KTtcbmRhc2hib2FyZC5hZGRXaWRnZXRzKG5ldyBjbG91ZHdhdGNoLkFsYXJtV2lkZ2V0KHtcbiAgdGl0bGU6ICdUb3RhbCBtZXNzYWdlcyBpbiBxdWV1ZScsXG4gIGFsYXJtLFxufSkpO1xuXG5kYXNoYm9hcmQuYWRkV2lkZ2V0cyhuZXcgY2xvdWR3YXRjaC5HcmFwaFdpZGdldCh7XG4gIHRpdGxlOiAnTW9yZSB0b3RhbCBtZXNzYWdlcyBpbiBxdWV1ZSB3aXRoIGFsYXJtIGFubm90YXRpb24nLFxuICBsZWZ0OiBbc3VtRXhwcmVzc2lvbl0sXG4gIHJpZ2h0OiBbbWV0cmljQSwgbWV0cmljQl0sXG4gIGxlZnRBbm5vdGF0aW9uczogW2FsYXJtLnRvQW5ub3RhdGlvbigpXVxufSkpO1xuXG5kYXNoYm9hcmQuYWRkV2lkZ2V0cyhuZXcgY2xvdWR3YXRjaC5TaW5nbGVWYWx1ZVdpZGdldCh7XG4gIHRpdGxlOiAnQ3VycmVudCB0b3RhbCBtZXNzYWdlcyBpbiBxdWV1ZScsXG4gIG1ldHJpY3M6IFtzdW1FeHByZXNzaW9uXVxufSkpO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==