"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudwatch = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudwatch');
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metric = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') }
});
const alarm = metric.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
    datapointsToAlarm: 2,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyCustomDashboardName',
    start: '-9H',
    end: '2018-12-17T06:00:00.000Z',
    periodOverride: cloudwatch.PeriodOverride.INHERIT
});
dashboard.addWidgets(new cloudwatch.TextWidget({ markdown: '# This is my dashboard' }), new cloudwatch.TextWidget({ markdown: 'you like?' }));
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More messages in queue with alarm annotation',
    left: [metric],
    leftAnnotations: [alarm.toAnnotation()]
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current messages in queue',
    metrics: [metric]
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYWxhcm0tYW5kLWRhc2hib2FyZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmFsYXJtLWFuZC1kYXNoYm9hcmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDJGQUEyRjtBQUMzRixFQUFFO0FBQ0Ysb0dBQW9HO0FBQ3BHLDhGQUE4RjtBQUM5RixtQkFBbUI7O0FBRW5CLHFDQUFxQztBQUNyQyxxQ0FBcUM7QUFFckMsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0FBRXZELE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFLEVBQUUsSUFBSSxFQUFFLGlCQUFpQixFQUFFLENBQUMsQ0FBQztBQUUvRSxNQUFNLE1BQU0sR0FBRyxJQUFJLFVBQVUsQ0FBQyxNQUFNLENBQUM7SUFDbkMsU0FBUyxFQUFFLFNBQVM7SUFDcEIsVUFBVSxFQUFFLG9DQUFvQztJQUNoRCxVQUFVLEVBQUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsRUFBRTtDQUNyRCxDQUFDLENBQUM7QUFFSCxNQUFNLEtBQUssR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUU7SUFDL0MsU0FBUyxFQUFFLEdBQUc7SUFDZCxpQkFBaUIsRUFBRSxDQUFDO0lBQ3BCLGlCQUFpQixFQUFFLENBQUM7Q0FDckIsQ0FBQyxDQUFDO0FBRUgsTUFBTSxTQUFTLEdBQUcsSUFBSSxVQUFVLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7SUFDeEQsYUFBYSxFQUFFLHVCQUF1QjtJQUN0QyxLQUFLLEVBQUUsS0FBSztJQUNaLEdBQUcsRUFBRSwwQkFBMEI7SUFDL0IsY0FBYyxFQUFFLFVBQVUsQ0FBQyxjQUFjLENBQUMsT0FBTztDQUNsRCxDQUFDLENBQUM7QUFDSCxTQUFTLENBQUMsVUFBVSxDQUNsQixJQUFJLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRSxRQUFRLEVBQUUsd0JBQXdCLEVBQUUsQ0FBQyxFQUNqRSxJQUFJLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FDckQsQ0FBQztBQUNGLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxVQUFVLENBQUMsV0FBVyxDQUFDO0lBQzlDLEtBQUssRUFBRSxtQkFBbUI7SUFDMUIsS0FBSztDQUNOLENBQUMsQ0FBQyxDQUFDO0FBQ0osU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxXQUFXLENBQUM7SUFDOUMsS0FBSyxFQUFFLDhDQUE4QztJQUNyRCxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUM7SUFDZCxlQUFlLEVBQUUsQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7Q0FDeEMsQ0FBQyxDQUFDLENBQUM7QUFDSixTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksVUFBVSxDQUFDLGlCQUFpQixDQUFDO0lBQ3BELEtBQUssRUFBRSwyQkFBMkI7SUFDbEMsT0FBTyxFQUFFLENBQUMsTUFBTSxDQUFDO0NBQ2xCLENBQUMsQ0FBQyxDQUFDO0FBRUosR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gSW50ZWdyYXRpb24gdGVzdCB0byBkZXBsb3kgc29tZSByZXNvdXJjZXMsIGNyZWF0ZSBhbiBhbGFybSBvbiBpdCBhbmQgY3JlYXRlIGEgZGFzaGJvYXJkLlxuLy9cbi8vIEJlY2F1c2UgbGl0ZXJhbGx5IGV2ZXJ5IG90aGVyIGxpYnJhcnkgaXMgZ29pbmcgdG8gZGVwZW5kIG9uIEBhd3MtY2RrL2F3cy1jbG91ZHdhdGNoLCB3ZSBkcm9wIGRvd25cbi8vIHRvIHRoZSB2ZXJ5IGxvd2VzdCBsZXZlbCB0byBjcmVhdGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2VzIGJ5IGhhbmQsIHdpdGhvdXQgZXZlbiBnZW5lcmF0ZWRcbi8vIGxpYnJhcnkgc3VwcG9ydC5cblxuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jbG91ZHdhdGNoJyk7XG5cbmNvbnN0IHF1ZXVlID0gbmV3IGNkay5DZm5SZXNvdXJjZShzdGFjaywgJ3F1ZXVlJywgeyB0eXBlOiAnQVdTOjpTUVM6OlF1ZXVlJyB9KTtcblxuY29uc3QgbWV0cmljID0gbmV3IGNsb3Vkd2F0Y2guTWV0cmljKHtcbiAgbmFtZXNwYWNlOiAnQVdTL1NRUycsXG4gIG1ldHJpY05hbWU6ICdBcHByb3hpbWF0ZU51bWJlck9mTWVzc2FnZXNWaXNpYmxlJyxcbiAgZGltZW5zaW9uczogeyBRdWV1ZU5hbWU6IHF1ZXVlLmdldEF0dCgnUXVldWVOYW1lJykgfVxufSk7XG5cbmNvbnN0IGFsYXJtID0gbWV0cmljLmNyZWF0ZUFsYXJtKHN0YWNrLCAnQWxhcm0nLCB7XG4gIHRocmVzaG9sZDogMTAwLFxuICBldmFsdWF0aW9uUGVyaW9kczogMyxcbiAgZGF0YXBvaW50c1RvQWxhcm06IDIsXG59KTtcblxuY29uc3QgZGFzaGJvYXJkID0gbmV3IGNsb3Vkd2F0Y2guRGFzaGJvYXJkKHN0YWNrLCAnRGFzaCcsIHtcbiAgZGFzaGJvYXJkTmFtZTogJ015Q3VzdG9tRGFzaGJvYXJkTmFtZScsXG4gIHN0YXJ0OiAnLTlIJyxcbiAgZW5kOiAnMjAxOC0xMi0xN1QwNjowMDowMC4wMDBaJyxcbiAgcGVyaW9kT3ZlcnJpZGU6IGNsb3Vkd2F0Y2guUGVyaW9kT3ZlcnJpZGUuSU5IRVJJVFxufSk7XG5kYXNoYm9hcmQuYWRkV2lkZ2V0cyhcbiAgbmV3IGNsb3Vkd2F0Y2guVGV4dFdpZGdldCh7IG1hcmtkb3duOiAnIyBUaGlzIGlzIG15IGRhc2hib2FyZCcgfSksXG4gIG5ldyBjbG91ZHdhdGNoLlRleHRXaWRnZXQoeyBtYXJrZG93bjogJ3lvdSBsaWtlPycgfSksXG4pO1xuZGFzaGJvYXJkLmFkZFdpZGdldHMobmV3IGNsb3Vkd2F0Y2guQWxhcm1XaWRnZXQoe1xuICB0aXRsZTogJ01lc3NhZ2VzIGluIHF1ZXVlJyxcbiAgYWxhcm0sXG59KSk7XG5kYXNoYm9hcmQuYWRkV2lkZ2V0cyhuZXcgY2xvdWR3YXRjaC5HcmFwaFdpZGdldCh7XG4gIHRpdGxlOiAnTW9yZSBtZXNzYWdlcyBpbiBxdWV1ZSB3aXRoIGFsYXJtIGFubm90YXRpb24nLFxuICBsZWZ0OiBbbWV0cmljXSxcbiAgbGVmdEFubm90YXRpb25zOiBbYWxhcm0udG9Bbm5vdGF0aW9uKCldXG59KSk7XG5kYXNoYm9hcmQuYWRkV2lkZ2V0cyhuZXcgY2xvdWR3YXRjaC5TaW5nbGVWYWx1ZVdpZGdldCh7XG4gIHRpdGxlOiAnQ3VycmVudCBtZXNzYWdlcyBpbiBxdWV1ZScsXG4gIG1ldHJpY3M6IFttZXRyaWNdXG59KSk7XG5cbmFwcC5zeW50aCgpO1xuIl19