"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const widget_1 = require("./widget");
/**
 * A dashboard widget that displays MarkDown
 */
class TextWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 2);
        this.markdown = props.markdown;
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
    toJson() {
        return [{
                type: 'text',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    markdown: this.markdown
                }
            }];
    }
}
exports.TextWidget = TextWidget;
//# sourceMappingURL=data:application/json;base64,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