import { Statistic } from '../metric-types';
export interface SimpleStatistic {
    type: 'simple';
    statistic: Statistic;
}
export interface PercentileStatistic {
    type: 'percentile';
    percentile: number;
}
/**
 * Parse a statistic, returning the type of metric that was used (simple or percentile)
 */
export declare function parseStatistic(stat: string): SimpleStatistic | PercentileStatistic;
export declare function normalizeStatistic(stat: string): string;
