# generated by scripts/generate_messages.py
from typing import Optional

import twnet_parser.msg7
from twnet_parser.net_message import NetMessage

import twnet_parser.messages7.system.info as \
       system7_info
import twnet_parser.messages7.system.map_change as \
       system7_map_change
import twnet_parser.messages7.system.map_data as \
       system7_map_data
import twnet_parser.messages7.system.server_info as \
       system7_server_info
import twnet_parser.messages7.system.con_ready as \
       system7_con_ready
import twnet_parser.messages7.system.snap as \
       system7_snap
import twnet_parser.messages7.system.snap_empty as \
       system7_snap_empty
import twnet_parser.messages7.system.snap_single as \
       system7_snap_single
import twnet_parser.messages7.system.input_timing as \
       system7_input_timing
import twnet_parser.messages7.system.rcon_auth_on as \
       system7_rcon_auth_on
import twnet_parser.messages7.system.rcon_auth_off as \
       system7_rcon_auth_off
import twnet_parser.messages7.system.rcon_line as \
       system7_rcon_line
import twnet_parser.messages7.system.rcon_cmd_add as \
       system7_rcon_cmd_add
import twnet_parser.messages7.system.rcon_cmd_rem as \
       system7_rcon_cmd_rem
import twnet_parser.messages7.system.ready as \
       system7_ready
import twnet_parser.messages7.system.enter_game as \
       system7_enter_game
import twnet_parser.messages7.system.input as \
       system7_input
import twnet_parser.messages7.system.rcon_cmd as \
       system7_rcon_cmd
import twnet_parser.messages7.system.rcon_auth as \
       system7_rcon_auth
import twnet_parser.messages7.system.request_map_data as \
       system7_request_map_data
import twnet_parser.messages7.system.ping as \
       system7_ping
import twnet_parser.messages7.system.ping_reply as \
       system7_ping_reply
import twnet_parser.messages7.system.maplist_entry_add as \
       system7_maplist_entry_add
import twnet_parser.messages7.system.maplist_entry_rem as \
       system7_maplist_entry_rem

def match_system7(msg_id: int, data: bytes) -> NetMessage:
    msg: Optional[NetMessage] = None

    if msg_id == twnet_parser.msg7.INFO:
        msg = system7_info.MsgInfo()
    elif msg_id == twnet_parser.msg7.MAP_CHANGE:
        msg = system7_map_change.MsgMapChange()
    elif msg_id == twnet_parser.msg7.MAP_DATA:
        msg = system7_map_data.MsgMapData()
    elif msg_id == twnet_parser.msg7.SERVER_INFO:
        msg = system7_server_info.MsgServerInfo()
    elif msg_id == twnet_parser.msg7.CON_READY:
        msg = system7_con_ready.MsgConReady()
    elif msg_id == twnet_parser.msg7.SNAP:
        msg = system7_snap.MsgSnap()
    elif msg_id == twnet_parser.msg7.SNAP_EMPTY:
        msg = system7_snap_empty.MsgSnapEmpty()
    elif msg_id == twnet_parser.msg7.SNAP_SINGLE:
        msg = system7_snap_single.MsgSnapSingle()
    elif msg_id == twnet_parser.msg7.INPUT_TIMING:
        msg = system7_input_timing.MsgInputTiming()
    elif msg_id == twnet_parser.msg7.RCON_AUTH_ON:
        msg = system7_rcon_auth_on.MsgRconAuthOn()
    elif msg_id == twnet_parser.msg7.RCON_AUTH_OFF:
        msg = system7_rcon_auth_off.MsgRconAuthOff()
    elif msg_id == twnet_parser.msg7.RCON_LINE:
        msg = system7_rcon_line.MsgRconLine()
    elif msg_id == twnet_parser.msg7.RCON_CMD_ADD:
        msg = system7_rcon_cmd_add.MsgRconCmdAdd()
    elif msg_id == twnet_parser.msg7.RCON_CMD_REM:
        msg = system7_rcon_cmd_rem.MsgRconCmdRem()
    elif msg_id == twnet_parser.msg7.READY:
        msg = system7_ready.MsgReady()
    elif msg_id == twnet_parser.msg7.ENTER_GAME:
        msg = system7_enter_game.MsgEnterGame()
    elif msg_id == twnet_parser.msg7.INPUT:
        msg = system7_input.MsgInput()
    elif msg_id == twnet_parser.msg7.RCON_CMD:
        msg = system7_rcon_cmd.MsgRconCmd()
    elif msg_id == twnet_parser.msg7.RCON_AUTH:
        msg = system7_rcon_auth.MsgRconAuth()
    elif msg_id == twnet_parser.msg7.REQUEST_MAP_DATA:
        msg = system7_request_map_data.MsgRequestMapData()
    elif msg_id == twnet_parser.msg7.PING:
        msg = system7_ping.MsgPing()
    elif msg_id == twnet_parser.msg7.PING_REPLY:
        msg = system7_ping_reply.MsgPingReply()
    elif msg_id == twnet_parser.msg7.MAPLIST_ENTRY_ADD:
        msg = system7_maplist_entry_add.MsgMaplistEntryAdd()
    elif msg_id == twnet_parser.msg7.MAPLIST_ENTRY_REM:
        msg = system7_maplist_entry_rem.MsgMaplistEntryRem()

    if msg is None:
        raise ValueError(f"Error: unknown system message id={msg_id} data={data[0]}")

    msg.unpack(data)
    return msg
