# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgMapChange(PrettyPrint):
    def __init__(
            self,
            name: str = 'default',
            crc: int = 0,
            size: int = 0,
            num_response_chunks_per_request: int = 0,
            chunk_size: int = 0,
            sha256: bytes = b'\x00'
    ) -> None:
        self.message_name = 'map_change'
        self.system_message = True
        self.header: ChunkHeader

        self.name: str = name
        self.crc: int = crc
        self.size: int = size
        self.num_response_chunks_per_request: int = num_response_chunks_per_request
        self.chunk_size: int = chunk_size
        self.sha256: bytes = sha256

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.name = unpacker.get_str()
        self.crc = unpacker.get_int()
        self.size = unpacker.get_int()
        self.num_response_chunks_per_request = unpacker.get_int()
        self.chunk_size = unpacker.get_int()
        self.sha256 = unpacker.get_raw()
        return True

    def pack(self) -> bytes:
        return pack_str(self.name) + \
            pack_int(self.crc) + \
            pack_int(self.size) + \
            pack_int(self.num_response_chunks_per_request) + \
            pack_int(self.chunk_size) + \
            self.sha256