# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgInfo(PrettyPrint):
    def __init__(
            self,
            version: str = 'default',
            password: str = '',
            client_version: int = 0
    ) -> None:
        self.message_name = 'info'
        self.system_message = True
        self.header: ChunkHeader

        self.version: str = version
        self.password: str = password
        self.client_version: int = client_version

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.version = unpacker.get_str()
        self.password = unpacker.get_str() # TODO: optionals
        self.client_version = unpacker.get_int() # TODO: optionals
        return True

    def pack(self) -> bytes:
        return pack_str(self.version) + \
            pack_str(self.password) + \
            pack_int(self.client_version)