# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvVoteStatus(PrettyPrint):
    def __init__(
            self,
            yes: int = 0,
            no: int = 0,
            pass_: int = 0,
            total: int = 0
    ) -> None:
        self.message_name = 'sv_vote_status'
        self.system_message = False
        self.header: ChunkHeader

        self.yes: int = yes
        self.no: int = no
        self.pass_: int = pass_
        self.total: int = total

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.yes = unpacker.get_int()
        self.no = unpacker.get_int()
        self.pass_ = unpacker.get_int()
        self.total = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.yes) + \
            pack_int(self.no) + \
            pack_int(self.pass_) + \
            pack_int(self.total)