# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import SANITIZE_CC, pack_int, pack_str

class MsgSvVoteSet(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            type: int = 0,
            timeout: int = 0,
            description: str = 'default',
            reason: str = 'default'
    ) -> None:
        self.message_name = 'sv_vote_set'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.type: int = type
        self.timeout: int = timeout
        self.description: str = description
        self.reason: str = reason

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.type = unpacker.get_int() # TODO: this is a enum
        self.timeout = unpacker.get_int()
        self.description = unpacker.get_str(SANITIZE_CC)
        self.reason = unpacker.get_str(SANITIZE_CC)
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_int(self.type) + \
            pack_int(self.timeout) + \
            pack_str(self.description) + \
            pack_str(self.reason)