# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import SANITIZE_CC, pack_str

class MsgSvVoteOptionAdd(PrettyPrint):
    def __init__(
            self,
            description: str = 'default'
    ) -> None:
        self.message_name = 'sv_vote_option_add'
        self.system_message = False
        self.header: ChunkHeader

        self.description: str = description

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.description = unpacker.get_str(SANITIZE_CC)
        return True

    def pack(self) -> bytes:
        return pack_str(self.description)