# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvTeam(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            team: int = 0,
            silent: bool = False,
            cooldown_tick: int = 0
    ) -> None:
        self.message_name = 'sv_team'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.team: int = team
        self.silent: bool = silent
        self.cooldown_tick: int = cooldown_tick

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.team = unpacker.get_int() # TODO: this is a enum
        self.silent = unpacker.get_int() == 1
        self.cooldown_tick = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_int(self.team) + \
            pack_int(self.silent) + \
            pack_int(self.cooldown_tick)