# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import SANITIZE_CC, pack_str

class MsgSvCommandInfo(PrettyPrint):
    def __init__(
            self,
            name: str = 'default',
            args_format: str = 'default',
            help_text: str = 'default'
    ) -> None:
        self.message_name = 'sv_command_info'
        self.system_message = False
        self.header: ChunkHeader

        self.name: str = name
        self.args_format: str = args_format
        self.help_text: str = help_text

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.name = unpacker.get_str(SANITIZE_CC)
        self.args_format = unpacker.get_str(SANITIZE_CC)
        self.help_text = unpacker.get_str(SANITIZE_CC)
        return True

    def pack(self) -> bytes:
        return pack_str(self.name) + \
            pack_str(self.args_format) + \
            pack_str(self.help_text)