# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import SANITIZE_CC, pack_int, pack_str
from typing import Annotated

class MsgClSkinChange(PrettyPrint):
    def __init__(
            self,
            skin_part_names: Annotated[list[str], 6] = \
                ['', '', '', '', '', ''],
            use_custom_colors: Annotated[list[bool], 6] = \
                [False, False, False, False, False, False],
            skin_part_colors: Annotated[list[int], 6] = \
                [0, 0, 0, 0, 0, 0]
    ) -> None:
        self.message_name = 'cl_skin_change'
        self.system_message = False
        self.header: ChunkHeader

        self.skin_part_names = skin_part_names
        self.use_custom_colors = use_custom_colors
        self.skin_part_colors = skin_part_colors

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        for i in range(0, 6):
            self.skin_part_names[i] = unpacker.get_str(SANITIZE_CC)
        for i in range(0, 6):
            self.use_custom_colors[i] = unpacker.get_int() == 1
        for i in range(0, 6):
            self.skin_part_colors[i] = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return b''.join([pack_str(x) for x in self.skin_part_names]) + \
            b''.join([pack_int(x) for x in self.use_custom_colors]) + \
            b''.join([pack_int(x) for x in self.skin_part_colors])