# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgClSetSpectatorMode(PrettyPrint):
    def __init__(
            self,
            spec_mode: int = 0,
            spectator_id: int = 0
    ) -> None:
        self.message_name = 'cl_set_spectator_mode'
        self.system_message = False
        self.header: ChunkHeader

        self.spec_mode: int = spec_mode
        self.spectator_id: int = spectator_id

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.spec_mode = unpacker.get_int() # TODO: this is a enum
        self.spectator_id = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.spec_mode) + \
            pack_int(self.spectator_id)