# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import SANITIZE_CC, pack_int, pack_str

class MsgClSay(PrettyPrint):
    def __init__(
            self,
            mode: int = 0,
            target: int = 0,
            message: str = 'default'
    ) -> None:
        self.message_name = 'cl_say'
        self.system_message = False
        self.header: ChunkHeader

        self.mode: int = mode
        self.target: int = target
        self.message: str = message

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.mode = unpacker.get_int() # TODO: this is a enum
        self.target = unpacker.get_int()
        self.message = unpacker.get_str(SANITIZE_CC)
        return True

    def pack(self) -> bytes:
        return pack_int(self.mode) + \
            pack_int(self.target) + \
            pack_str(self.message)