# auto-generated by FeatureByte (based-on databricks-feature-store {{databricks_sdk_version}})
# Import necessary modules for feature engineering and machine learning
from databricks.feature_engineering import FeatureEngineeringClient
from databricks.feature_engineering import FeatureFunction, FeatureLookup
from pyspark.sql import SparkSession
{{pyspark_import_statement}}
import mlflow

# Initialize the Feature Engineering client to interact with Databricks Feature Store
fe = FeatureEngineeringClient()

{% if require_timestamp_lookup_key -%}
# Timestamp column name used to retrieve the latest feature values
timestamp_lookup_key = "POINT_IN_TIME"

{% endif -%}
# Define the features for the model
# FeatureLookup is used to specify how to retrieve features from the feature store
# Each FeatureLookup or FeatureFunction object defines a set of features to be included
features = {{features}}

# List of columns to exclude from the training set
# Users should consider including request columns and primary entity columns here
# This is important if these columns are not features but are only needed for lookup purposes
exclude_columns = {{exclude_columns}}

# Prepare the dataset for log model
# 'features' is a list of feature lookups to be included in the training set
# 'exclude_columns' is a list of columns to be excluded from the training set
target_column = "{{target_column}}"
schema = {{schema}}
spark = SparkSession.builder.getOrCreate()
log_model_dataset = fe.create_training_set(
    df=spark.createDataFrame([], schema),
    feature_lookups=features,
    label=target_column,
    exclude_columns=exclude_columns,
)

{% if include_log_model -%}
# Log the model and register it to the unity catalog
fe.log_model(
    model=model,  # model is the trained model
    artifact_path="[ARTIFACT_PATH]",  # artifact_path is the path to the model
    flavor=mlflow.sklearn,
    training_set=log_model_dataset,
    registered_model_name="[REGISTERED_MODEL_NAME]",  # registered model name in the unity catalog
)
{% endif -%}
