import sys
from typing import Any, BinaryIO, ClassVar, FrozenSet, Union
from typing_extensions import Final, Literal

if sys.version_info >= (3, 6):
    from os import PathLike

_VALID_STATIC_ICON_FORMATS = Literal['jpeg', 'jpg', 'webp', 'png']
_VALID_ANIMATED_ICON_FORMATS = Literal[_VALID_STATIC_ICON_FORMATS, 'gif']

VALID_STATIC_FORMATS: Final[FrozenSet[_VALID_STATIC_ICON_FORMATS]]
VALID_AVATAR_FORMATS: Final[FrozenSet[_VALID_ANIMATED_ICON_FORMATS]]

class Asset:
    BASE: ClassVar[str]
    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    async def read(self) -> bytes: ...
    if sys.version_info >= (3, 6):
        async def save(
            self, fp: Union[BinaryIO, PathLike[str], str], *, seek_begin: bool = ...
        ) -> int: ...
    else:
        async def save(
            self, fp: Union[BinaryIO, str], *, seek_begin: bool = ...
        ) -> int: ...
