"""
    CryptoAPIs

    Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.create_coins_transaction_from_address_for_whole_amount_r import CreateCoinsTransactionFromAddressForWholeAmountR
from cryptoapis.model.create_coins_transaction_from_address_for_whole_amount_rb import CreateCoinsTransactionFromAddressForWholeAmountRB
from cryptoapis.model.create_coins_transaction_request_from_address_r import CreateCoinsTransactionRequestFromAddressR
from cryptoapis.model.create_coins_transaction_request_from_address_rb import CreateCoinsTransactionRequestFromAddressRB
from cryptoapis.model.create_coins_transaction_request_from_wallet_r import CreateCoinsTransactionRequestFromWalletR
from cryptoapis.model.create_coins_transaction_request_from_wallet_rb import CreateCoinsTransactionRequestFromWalletRB
from cryptoapis.model.create_fungible_tokens_transaction_request_from_address_r import CreateFungibleTokensTransactionRequestFromAddressR
from cryptoapis.model.create_fungible_tokens_transaction_request_from_address_rb import CreateFungibleTokensTransactionRequestFromAddressRB
from cryptoapis.model.inline_response40013 import InlineResponse40013
from cryptoapis.model.inline_response40020 import InlineResponse40020
from cryptoapis.model.inline_response40025 import InlineResponse40025
from cryptoapis.model.inline_response40036 import InlineResponse40036
from cryptoapis.model.inline_response40113 import InlineResponse40113
from cryptoapis.model.inline_response40120 import InlineResponse40120
from cryptoapis.model.inline_response40125 import InlineResponse40125
from cryptoapis.model.inline_response40136 import InlineResponse40136
from cryptoapis.model.inline_response402 import InlineResponse402
from cryptoapis.model.inline_response40313 import InlineResponse40313
from cryptoapis.model.inline_response40320 import InlineResponse40320
from cryptoapis.model.inline_response40325 import InlineResponse40325
from cryptoapis.model.inline_response40336 import InlineResponse40336
from cryptoapis.model.inline_response4091 import InlineResponse4091
from cryptoapis.model.inline_response4092 import InlineResponse4092
from cryptoapis.model.inline_response4093 import InlineResponse4093
from cryptoapis.model.inline_response4094 import InlineResponse4094
from cryptoapis.model.inline_response415 import InlineResponse415
from cryptoapis.model.inline_response422 import InlineResponse422
from cryptoapis.model.inline_response429 import InlineResponse429
from cryptoapis.model.inline_response500 import InlineResponse500


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_coins_transaction_from_address_for_whole_amount_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCoinsTransactionFromAddressForWholeAmountR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/all-transaction-requests',
                'operation_id': 'create_coins_transaction_from_address_for_whole_amount',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'blockchain',
                    'network',
                    'wallet_id',
                    'context',
                    'create_coins_transaction_from_address_for_whole_amount_rb',
                ],
                'required': [
                    'address',
                    'blockchain',
                    'network',
                    'wallet_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "ROPSTEN": "ropsten",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'wallet_id':
                        (str,),
                    'context':
                        (str,),
                    'create_coins_transaction_from_address_for_whole_amount_rb':
                        (CreateCoinsTransactionFromAddressForWholeAmountRB,),
                },
                'attribute_map': {
                    'address': 'address',
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'wallet_id': 'walletId',
                    'context': 'context',
                },
                'location_map': {
                    'address': 'path',
                    'blockchain': 'path',
                    'network': 'path',
                    'wallet_id': 'path',
                    'context': 'query',
                    'create_coins_transaction_from_address_for_whole_amount_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_coins_transaction_request_from_address_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCoinsTransactionRequestFromAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/transaction-requests',
                'operation_id': 'create_coins_transaction_request_from_address',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'blockchain',
                    'network',
                    'wallet_id',
                    'context',
                    'create_coins_transaction_request_from_address_rb',
                ],
                'required': [
                    'address',
                    'blockchain',
                    'network',
                    'wallet_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "ROPSTEN": "ropsten",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'wallet_id':
                        (str,),
                    'context':
                        (str,),
                    'create_coins_transaction_request_from_address_rb':
                        (CreateCoinsTransactionRequestFromAddressRB,),
                },
                'attribute_map': {
                    'address': 'address',
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'wallet_id': 'walletId',
                    'context': 'context',
                },
                'location_map': {
                    'address': 'path',
                    'blockchain': 'path',
                    'network': 'path',
                    'wallet_id': 'path',
                    'context': 'query',
                    'create_coins_transaction_request_from_address_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_coins_transaction_request_from_wallet_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCoinsTransactionRequestFromWalletR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transaction-requests',
                'operation_id': 'create_coins_transaction_request_from_wallet',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'wallet_id',
                    'context',
                    'create_coins_transaction_request_from_wallet_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'wallet_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'wallet_id':
                        (str,),
                    'context':
                        (str,),
                    'create_coins_transaction_request_from_wallet_rb':
                        (CreateCoinsTransactionRequestFromWalletRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'wallet_id': 'walletId',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'wallet_id': 'path',
                    'context': 'query',
                    'create_coins_transaction_request_from_wallet_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_fungible_tokens_transaction_request_from_address_endpoint = _Endpoint(
            settings={
                'response_type': (CreateFungibleTokensTransactionRequestFromAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{senderAddress}/token-transaction-requests',
                'operation_id': 'create_fungible_tokens_transaction_request_from_address',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'sender_address',
                    'wallet_id',
                    'context',
                    'create_fungible_tokens_transaction_request_from_address_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'sender_address',
                    'wallet_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "ROPSTEN": "ropsten",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'sender_address':
                        (str,),
                    'wallet_id':
                        (str,),
                    'context':
                        (str,),
                    'create_fungible_tokens_transaction_request_from_address_rb':
                        (CreateFungibleTokensTransactionRequestFromAddressRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'sender_address': 'senderAddress',
                    'wallet_id': 'walletId',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'sender_address': 'path',
                    'wallet_id': 'path',
                    'context': 'query',
                    'create_fungible_tokens_transaction_request_from_address_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_coins_transaction_from_address_for_whole_amount(
        self,
        address,
        blockchain,
        network,
        wallet_id,
        **kwargs
    ):
        """Create Coins Transaction From Address For Whole Amount  # noqa: E501

        Through this endpoint customers can create a new transaction from address for **coins** specifically, which will transfer over the entire available amount.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_coins_transaction_from_address_for_whole_amount(address, blockchain, network, wallet_id, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Defines the source address.
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            wallet_id (str): Represents the sender's specific and unique Wallet ID of the sender.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            create_coins_transaction_from_address_for_whole_amount_rb (CreateCoinsTransactionFromAddressForWholeAmountRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCoinsTransactionFromAddressForWholeAmountR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['wallet_id'] = \
            wallet_id
        return self.create_coins_transaction_from_address_for_whole_amount_endpoint.call_with_http_info(**kwargs)

    def create_coins_transaction_request_from_address(
        self,
        address,
        blockchain,
        network,
        wallet_id,
        **kwargs
    ):
        """Create Coins Transaction Request from Address  # noqa: E501

        Through this endpoint users can create a new single transaction request from one address to another.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_coins_transaction_request_from_address(address, blockchain, network, wallet_id, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Defines the specific source address for the transaction.
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            wallet_id (str): Represents the sender's specific and unique Wallet ID of the sender.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            create_coins_transaction_request_from_address_rb (CreateCoinsTransactionRequestFromAddressRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCoinsTransactionRequestFromAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['wallet_id'] = \
            wallet_id
        return self.create_coins_transaction_request_from_address_endpoint.call_with_http_info(**kwargs)

    def create_coins_transaction_request_from_wallet(
        self,
        blockchain,
        wallet_id,
        network="testnet",
        **kwargs
    ):
        """Create Coins Transaction Request from Wallet  # noqa: E501

        Through this endpoint users can create a new transaction request from the entire Wallet instead from just a specific address. This endpoint can generate transactions from multiple to multiple addresses.    {warning}This is available **only** for UTXO-based protocols such as Bitcoin, Bitcoin Cash, Litecoin, etc. It **is not** available for Account-based protocols like Ethereum.{/warning}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_coins_transaction_request_from_wallet(blockchain, wallet_id, network="testnet", async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            wallet_id (str): Represents the sender's specific and unique Wallet ID of the sender.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "testnet", must be one of ["testnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            create_coins_transaction_request_from_wallet_rb (CreateCoinsTransactionRequestFromWalletRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateCoinsTransactionRequestFromWalletR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['wallet_id'] = \
            wallet_id
        return self.create_coins_transaction_request_from_wallet_endpoint.call_with_http_info(**kwargs)

    def create_fungible_tokens_transaction_request_from_address(
        self,
        sender_address,
        wallet_id,
        blockchain="ethereum",
        network="mainnet",
        **kwargs
    ):
        """Create Fungible Tokens Transaction Request from Address  # noqa: E501

        Through this endpoint users can make a single token transaction.    {note}To have an operational callback subscription, you need to first verify a domain for the Callback URL. Please see more information on Callbacks [here](https://developers.cryptoapis.io/technical-documentation/general-information/callbacks#callback-url).{/note}    {warning}Crypto APIs will notify the user **only when** the event occurs. There are cases when the specific event doesn't happen at all, or takes a long time to do so. A callback notification **will not** be sent if the event does not or cannot occur, or will take long time to occur.{/warning}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fungible_tokens_transaction_request_from_address(sender_address, wallet_id, blockchain="ethereum", network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            sender_address (str): Defines the specific source address for the transaction.
            wallet_id (str): Defines the unique ID of the Wallet.
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.. defaults to "ethereum", must be one of ["ethereum"]
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            create_fungible_tokens_transaction_request_from_address_rb (CreateFungibleTokensTransactionRequestFromAddressRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateFungibleTokensTransactionRequestFromAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['sender_address'] = \
            sender_address
        kwargs['wallet_id'] = \
            wallet_id
        return self.create_fungible_tokens_transaction_request_from_address_endpoint.call_with_http_info(**kwargs)

