
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in viscm
parameters = {'xp': [-4.9044626459399012, 9.97648973501245, 34.597701856224575, 41.361771120293838, 42.985147743670467, 40.820645579168314, 34.868264626787351, 10.517615276138002, 9.4353641938869259],
              'yp': [-30.735930735930708, -35.064935064935042, -19.101731601731586, -2.3268398268398016, 14.718614718614731, 23.647186147186176, 30.140692640692663, 28.78787878787881, 23.917748917748924],
              'min_Jp': 18.1236038719,
              'max_Jp': 75.7557706627}

cm_data = [[ 0.05309761, 0.02765358, 0.57567508],
           [ 0.06660787, 0.02434601, 0.57973405],
           [ 0.0785568 , 0.02135181, 0.58346076],
           [ 0.08939909, 0.01867147, 0.58687144],
           [ 0.09940638, 0.01630231, 0.58998262],
           [ 0.10875606, 0.01423902, 0.59281085],
           [ 0.11757076, 0.01247489, 0.59537244],
           [ 0.12592751, 0.01101599, 0.59768191],
           [ 0.13390902, 0.00983502, 0.59975751],
           [ 0.1415683 , 0.00892002, 0.60161437],
           [ 0.14894758, 0.00825842, 0.60326698],
           [ 0.15608122, 0.00783726, 0.60472917],
           [ 0.16298542, 0.00765897, 0.60601441],
           [ 0.16969712, 0.00769376, 0.60713563],
           [ 0.17623673, 0.00792811, 0.60810447],
           [ 0.18262151, 0.0083491 , 0.60893196],
           [ 0.18886137, 0.00895062, 0.60962923],
           [ 0.19496922, 0.00972059, 0.6102065 ],
           [ 0.20096261, 0.01063905, 0.61067195],
           [ 0.20685149, 0.0116947 , 0.61103397],
           [ 0.21264204, 0.01288018, 0.61130119],
           [ 0.21833889, 0.01418948, 0.61148226],
           [ 0.22395598, 0.01560351, 0.61158205],
           [ 0.22949954, 0.017113  , 0.6116068 ],
           [ 0.23497253, 0.01871268, 0.6115635 ],
           [ 0.24037845, 0.02039634, 0.61145852],
           [ 0.24572711, 0.0221491 , 0.61129471],
           [ 0.25102262, 0.02396359, 0.61107668],
           [ 0.2562652 , 0.02583764, 0.61081062],
           [ 0.26146007, 0.02776231, 0.61049975],
           [ 0.26661301, 0.02972782, 0.61014626],
           [ 0.27172685, 0.0317284 , 0.60975347],
           [ 0.27679986, 0.03376471, 0.60932731],
           [ 0.28183936, 0.03582485, 0.60886756],
           [ 0.28684781, 0.03790366, 0.6083766 ],
           [ 0.29182577, 0.0399988 , 0.60785786],
           [ 0.29677486, 0.04205962, 0.60731377],
           [ 0.30169931, 0.04405991, 0.60674447],
           [ 0.30660069, 0.04600647, 0.60615172],
           [ 0.31147816, 0.04790318, 0.60553906],
           [ 0.31633589, 0.04974712, 0.60490571],
           [ 0.32117539, 0.05153889, 0.60425274],
           [ 0.32599699, 0.05328063, 0.60358207],
           [ 0.33080215, 0.05497281, 0.60289446],
           [ 0.33559309, 0.05661499, 0.60218974],
           [ 0.34037066, 0.0582083 , 0.60146879],
           [ 0.34513502, 0.05975469, 0.60073301],
           [ 0.34988845, 0.06125339, 0.59998161],
           [ 0.35463173, 0.06270541, 0.59921506],
           [ 0.35936533, 0.06411205, 0.59843401],
           [ 0.36409055, 0.06547354, 0.59763816],
           [ 0.36880824, 0.06679056, 0.59682752],
           [ 0.37351904, 0.06806398, 0.59600219],
           [ 0.37822389, 0.06929426, 0.59516186],
           [ 0.38292342, 0.07048213, 0.59430642],
           [ 0.38761812, 0.07162843, 0.59343582],
           [ 0.39230921, 0.07273308, 0.59254913],
           [ 0.39699686, 0.07379718, 0.59164645],
           [ 0.40168146, 0.07482151, 0.5907276 ],
           [ 0.40636404, 0.07580601, 0.58979155],
           [ 0.41104513, 0.07675118, 0.58883778],
           [ 0.41572466, 0.07765821, 0.58786642],
           [ 0.42040316, 0.07852746, 0.58687679],
           [ 0.42508217, 0.07935804, 0.58586694],
           [ 0.42976084, 0.08015195, 0.58483778],
           [ 0.43443942, 0.08090976, 0.58378881],
           [ 0.43911958, 0.08163023, 0.58271766],
           [ 0.44380089, 0.08231471, 0.58162458],
           [ 0.44848307, 0.08296435, 0.58050964],
           [ 0.45316687, 0.08357889, 0.57937146],
           [ 0.45785367, 0.08415726, 0.57820778],
           [ 0.46254209, 0.08470188, 0.57702   ],
           [ 0.46723226, 0.08521324, 0.57580751],
           [ 0.4719262 , 0.08568923, 0.57456694],
           [ 0.47662293, 0.08613168, 0.57329911],
           [ 0.48132194, 0.08654182, 0.57200418],
           [ 0.48602379, 0.08691939, 0.57068079],
           [ 0.49073037, 0.08726222, 0.56932546],
           [ 0.49543959, 0.08757359, 0.56794064],
           [ 0.50015148, 0.08785391, 0.56652563],
           [ 0.50486763, 0.08810128, 0.56507733],
           [ 0.50958796, 0.08831615, 0.5635951 ],
           [ 0.51431112, 0.08850072, 0.56208028],
           [ 0.51903711, 0.08865533, 0.56053219],
           [ 0.52376837, 0.08877665, 0.5589461 ],
           [ 0.5285031 , 0.08886753, 0.55732411],
           [ 0.53324065, 0.08892916, 0.5556665 ],
           [ 0.53798094, 0.08896186, 0.55397262],
           [ 0.54272702, 0.08896118, 0.5522365 ],
           [ 0.54747586, 0.08893179, 0.55046235],
           [ 0.5522273 , 0.08887416, 0.54864969],
           [ 0.55698123, 0.08878855, 0.54679786],
           [ 0.56174073, 0.08867016, 0.54490051],
           [ 0.56650253, 0.08852422, 0.54296255],
           [ 0.57126649, 0.08835106, 0.54098339],
           [ 0.57603245, 0.088151  , 0.53896249],
           [ 0.58080312, 0.08791955, 0.53689381],
           [ 0.58557589, 0.08766106, 0.53478136],
           [ 0.59035019, 0.08737647, 0.53262529],
           [ 0.59512585, 0.08706617, 0.53042509],
           [ 0.59990447, 0.08672733, 0.52817666],
           [ 0.60468542, 0.08636096, 0.52588021],
           [ 0.60946713, 0.08596987, 0.523538  ],
           [ 0.61424936, 0.0855545 , 0.52114958],
           [ 0.61903188, 0.08511531, 0.51871456],
           [ 0.62381748, 0.08464706, 0.51622597],
           [ 0.6286029 , 0.08415581, 0.51368973],
           [ 0.63338785, 0.08364216, 0.51110554],
           [ 0.63817203, 0.08310674, 0.50847304],
           [ 0.64295538, 0.08254979, 0.50579147],
           [ 0.64774008, 0.081967  , 0.50305476],
           [ 0.65252312, 0.08136444, 0.50026868],
           [ 0.65730419, 0.08074292, 0.49743294],
           [ 0.66208296, 0.08010337, 0.4945473 ],
           [ 0.6668591 , 0.07944675, 0.49161152],
           [ 0.67163395, 0.07877048, 0.4886212 ],
           [ 0.67640634, 0.07807733, 0.48557796],
           [ 0.68117498, 0.07737055, 0.48248389],
           [ 0.68593948, 0.07665153, 0.47933882],
           [ 0.69069946, 0.07592179, 0.47614262],
           [ 0.69545451, 0.07518297, 0.47289514],
           [ 0.70020514, 0.07443463, 0.46959368],
           [ 0.70495119, 0.07367802, 0.46623733],
           [ 0.70969093, 0.07291827, 0.46282941],
           [ 0.71442389, 0.07215771, 0.45936986],
           [ 0.7191496 , 0.07139891, 0.45585863],
           [ 0.72386756, 0.07064463, 0.4522957 ],
           [ 0.72857726, 0.0698979 , 0.44868106],
           [ 0.73327815, 0.06916198, 0.44501469],
           [ 0.73797067, 0.0684378 , 0.44129359],
           [ 0.74265376, 0.06773039, 0.43751914],
           [ 0.74732625, 0.06704543, 0.4336932 ],
           [ 0.7519875 , 0.0663874 , 0.42981587],
           [ 0.75663688, 0.06576107, 0.42588722],
           [ 0.76127372, 0.06517155, 0.42190739],
           [ 0.76589734, 0.0646243 , 0.41787648],
           [ 0.77050701, 0.0641251 , 0.41379466],
           [ 0.77510198, 0.06368005, 0.40966209],
           [ 0.77968148, 0.0632956 , 0.40547895],
           [ 0.78424469, 0.06297845, 0.40124544],
           [ 0.78879077, 0.06273562, 0.3969618 ],
           [ 0.79331883, 0.06257433, 0.39262826],
           [ 0.79782796, 0.06250201, 0.38824511],
           [ 0.80231719, 0.0625262 , 0.38381264],
           [ 0.80678552, 0.06265454, 0.37933118],
           [ 0.81123191, 0.06289467, 0.37480109],
           [ 0.81565526, 0.06325413, 0.37022275],
           [ 0.82005444, 0.06374032, 0.36559658],
           [ 0.82442824, 0.06436042, 0.36092305],
           [ 0.82877542, 0.06512124, 0.35620264],
           [ 0.83309468, 0.06602922, 0.3514359 ],
           [ 0.83738465, 0.0670903 , 0.34662342],
           [ 0.84164393, 0.06830988, 0.34176582],
           [ 0.84587101, 0.06969273, 0.33686379],
           [ 0.85006436, 0.07124301, 0.33191806],
           [ 0.85422236, 0.07296419, 0.32692944],
           [ 0.85834332, 0.07485904, 0.32189878],
           [ 0.86242549, 0.07692968, 0.31682702],
           [ 0.86646704, 0.07917755, 0.31171513],
           [ 0.87046607, 0.08160343, 0.30656421],
           [ 0.87442119, 0.08420662, 0.30137077],
           [ 0.87833001, 0.08698756, 0.29613785],
           [ 0.88219009, 0.08994599, 0.2908692 ],
           [ 0.88599921, 0.09308064, 0.28556626],
           [ 0.88975507, 0.09638984, 0.28023058],
           [ 0.89345533, 0.09987153, 0.2748638 ],
           [ 0.89709804, 0.10352348, 0.26946107],
           [ 0.90068031, 0.10734356, 0.26402769],
           [ 0.90419933, 0.11132898, 0.25856871],
           [ 0.90765249, 0.11547665, 0.25308626],
           [ 0.91103723, 0.11978374, 0.24757981],
           [ 0.91435089, 0.12424795, 0.24204682],
           [ 0.91759042, 0.12886475, 0.23649776],
           [ 0.92075309, 0.13363034, 0.23093538],
           [ 0.92383614, 0.13854243, 0.22535634],
           [ 0.92683669, 0.14359677, 0.21976584],
           [ 0.92975211, 0.14878801, 0.21417154],
           [ 0.93257967, 0.15411281, 0.20857341],
           [ 0.9353166 , 0.15956763, 0.20297249],
           [ 0.93796078, 0.1651455 , 0.19737897],
           [ 0.94050971, 0.1708426 , 0.19179353],
           [ 0.94296107, 0.17665432, 0.18621905],
           [ 0.9453134 , 0.18257312, 0.18066473],
           [ 0.94756459, 0.18859492, 0.17513136],
           [ 0.94971337, 0.19471298, 0.16962553],
           [ 0.95175887, 0.20092016, 0.16415405],
           [ 0.95369972, 0.20721165, 0.15871899],
           [ 0.95553588, 0.21357931, 0.15332885],
           [ 0.95726703, 0.22001679, 0.14798859],
           [ 0.95889329, 0.22651724, 0.1427042 ],
           [ 0.96041508, 0.23307393, 0.13748175],
           [ 0.96183341, 0.2396794 , 0.13232879],
           [ 0.96314915, 0.24632745, 0.12725128],
           [ 0.9643634 , 0.25301197, 0.12225572],
           [ 0.96547871, 0.25972444, 0.11735313],
           [ 0.96649572, 0.2664613 , 0.1125477 ],
           [ 0.96741698, 0.2732154 , 0.10785035],
           [ 0.96824515, 0.27998027, 0.10327209],
           [ 0.96898111, 0.28675336, 0.09881957],
           [ 0.96962858, 0.29352721, 0.09450826],
           [ 0.97018982, 0.30029774, 0.09035031],
           [ 0.97066588, 0.30706328, 0.08635642],
           [ 0.97106075, 0.3138174 , 0.08254584],
           [ 0.97137701, 0.32055663, 0.07893557],
           [ 0.97161529, 0.3272808 , 0.07554017],
           [ 0.9717784 , 0.33398642, 0.07238057],
           [ 0.97187122, 0.34066724, 0.06948243],
           [ 0.97189286, 0.34732594, 0.0668615 ],
           [ 0.97184539, 0.35396069, 0.06454003],
           [ 0.97173225, 0.36056797, 0.06254211],
           [ 0.97155612, 0.36714556, 0.06088925],
           [ 0.97131664, 0.3736954 , 0.05959704],
           [ 0.97101554, 0.38021654, 0.05868167],
           [ 0.97065469, 0.38670795, 0.05815594],
           [ 0.97023823, 0.39316591, 0.05803019],
           [ 0.96976463, 0.39959372, 0.05830448],
           [ 0.96923523, 0.40599107, 0.05897716],
           [ 0.96865129, 0.41235775, 0.06004171],
           [ 0.96801398, 0.41869364, 0.06148723],
           [ 0.96732635, 0.42499659, 0.06329967],
           [ 0.96658718, 0.43126916, 0.06546049],
           [ 0.9657973 , 0.43751154, 0.06795034],
           [ 0.96495753, 0.44372393, 0.07074881],
           [ 0.96406862, 0.44990655, 0.07383522],
           [ 0.96313126, 0.45605966, 0.07718926],
           [ 0.96214662, 0.46218303, 0.0807914 ],
           [ 0.96111424, 0.46827798, 0.08462368],
           [ 0.96003459, 0.47434484, 0.08866957],
           [ 0.9589081 , 0.48038396, 0.09291423],
           [ 0.95773516, 0.48639566, 0.09734451],
           [ 0.95651613, 0.49238026, 0.10194901],
           [ 0.95525034, 0.49833892, 0.10671854],
           [ 0.95393783, 0.5042721 , 0.11164532],
           [ 0.95257931, 0.51017962, 0.11672276],
           [ 0.95117503, 0.51606169, 0.121946  ],
           [ 0.94972529, 0.52191839, 0.12731163],
           [ 0.94823044, 0.52774975, 0.13281765],
           [ 0.94668519, 0.53356011, 0.1384677 ],
           [ 0.94509381, 0.53934613, 0.14426019],
           [ 0.94345723, 0.54510718, 0.15019731],
           [ 0.94177633, 0.55084259, 0.15628289],
           [ 0.94004523, 0.55655653, 0.16252849],
           [ 0.93826433, 0.56224826, 0.16894303],
           [ 0.93644119, 0.56791198, 0.17553146],
           [ 0.93457307, 0.5735491 , 0.18231101],
           [ 0.93264972, 0.57916572, 0.18931129],
           [ 0.93069317, 0.58474582, 0.19653516],
           [ 0.92868255, 0.59030183, 0.20403697],
           [ 0.92664509, 0.59581404, 0.21183032],
           [ 0.92456249, 0.60129151, 0.21999539],
           [ 0.92247312, 0.60670657, 0.22856835],
           [ 0.92039123, 0.61204575, 0.23764896],
           [ 0.918349  , 0.61728213, 0.24737718],
           [ 0.91645204, 0.62234256, 0.25788678],
           [ 0.91489602, 0.62709876, 0.26932624],
           [ 0.91410321, 0.63129811, 0.28157637]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
