import pytest

from typing import List
from datetime import datetime, timezone


from tessdbapi.model import ReadingInfo1c, ReadingInfo4c, ReadingInfo


@pytest.fixture()
def stars701() -> ReadingInfo4c:
    return ReadingInfo4c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars701",
        sequence_number=1,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
        freq1=10,
        mag1=23.4,
        freq2=11,
        mag2=23.5,
        freq3=12,
        mag3=23.6,
        freq4=13,
        mag4=23.7,
    )


@pytest.fixture()
def stars701_seq() -> List[ReadingInfo4c]:
    return [
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 00, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=1,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 1, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=2,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=3,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 4, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=5,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
    ]

@pytest.fixture()
def stars_mixed() -> List[ReadingInfo]:
    return [
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 00, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=0,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 00, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=1,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 1, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=1,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=2,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 1, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=2,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 4, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=4,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 5, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=5,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=3,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 6, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=6,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 7, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=7,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo4c(
            tstamp=datetime(2025, 9, 4, 00, 4, 00, tzinfo=timezone.utc),
            name="stars701",
            sequence_number=5,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
            freq1=10,
            mag1=23.4,
            freq2=11,
            mag2=23.5,
            freq3=12,
            mag3=23.6,
            freq4=13,
            mag4=23.7,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 8, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=8,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 9, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=9,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
    ]
    

@pytest.fixture()
def stars8000r1() -> ReadingInfo1c:
    return ReadingInfo1c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars8000",
        sequence_number=1,
        freq1=10,
        mag1=23.4,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
    )


@pytest.fixture()
def stars1r1() -> ReadingInfo1c:
    return ReadingInfo1c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars1",
        sequence_number=1,
        freq1=10,
        mag1=23.4,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
    )


@pytest.fixture()
def stars1r1_wrong_hash() -> ReadingInfo1c:
    return ReadingInfo1c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars1",
        sequence_number=1,
        freq1=10,
        mag1=23.4,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
        hash="ABC",
    )


@pytest.fixture()
def stars1r1_good_hash() -> ReadingInfo1c:
    return ReadingInfo1c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars1",
        sequence_number=1,
        freq1=10,
        mag1=23.4,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
        hash="95A",
    )


@pytest.fixture()
def stars100r1() -> ReadingInfo1c:
    return ReadingInfo1c(
        tstamp=datetime(2025, 9, 4, 12, 34, 56, tzinfo=timezone.utc),
        name="stars100",
        sequence_number=1,
        freq1=10,
        mag1=23.4,
        box_temperature=12,
        sky_temperature=-12,
        signal_strength=-78,
    )


@pytest.fixture()
def stars1_dense() -> List[ReadingInfo1c]:
    return [
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 00, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=0,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 1, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=1,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=2,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 4, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=4,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 5, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=5,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 6, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=6,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 7, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=7,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 8, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=8,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 9, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=9,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
    ]


@pytest.fixture()
def stars1_sparse() -> List[ReadingInfo1c]:
    return [
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=2,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 5, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=5,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 7, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=7,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
    ]


@pytest.fixture()
def stars1_sparse_dup() -> List[ReadingInfo1c]:
    return [
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=2,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 7, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=7,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
    ]


@pytest.fixture()
def stars1_mixed() -> List[ReadingInfo1c]:
    return [
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 00, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=0,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 1, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=1,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 2, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=2,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 3, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=3,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 4, 00, tzinfo=timezone.utc),
            name="stars8000",
            sequence_number=4,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 5, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=5,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 6, 00, tzinfo=timezone.utc),
            name="stars8000",
            sequence_number=6,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 7, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=7,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 8, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=8,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
        ReadingInfo1c(
            tstamp=datetime(2025, 9, 4, 00, 9, 00, tzinfo=timezone.utc),
            name="stars1",
            sequence_number=9,
            freq1=10,
            mag1=23.4,
            box_temperature=12,
            sky_temperature=-12,
            signal_strength=-78,
        ),
    ]
