"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoBackedCustomResource = void 0;
const dynamodb_1 = require("../dynamodb");
const simple_resource_1 = require("./simple-resource");
/* istanbul ignore file */
class DynamoBackedCustomResource extends simple_resource_1.SimpleCustomResource {
    constructor(dynamoDbClient) {
        super();
        this.dynamoDbClient = dynamoDbClient;
        if (!process.env.DATABASE) {
            throw Error("Cannot retrieve value of 'DATABASE' environment variable");
        }
        this.tableName = process.env.DATABASE;
        console.log(`Using DynamoDB Table for recording state: ${this.tableName}`);
    }
    /**
     * This method is provided to do a quick permisions check on the database to make sure that all operations that are
     * performed by the CompositeStringIndexTable are available.
     */
    async databasePermissionsCheck(database) {
        if (!this.debugMode) {
            return;
        }
        const uniqueContent = new Date().toISOString();
        const physicalId = `TestingItem${uniqueContent}`;
        await database.putItem({
            primaryKeyValue: physicalId,
            sortKeyValue: `SortValue${uniqueContent}`,
            attributes: {
                Key: `TestKey${uniqueContent}`,
            },
        });
        await database.getItem({
            primaryKeyValue: physicalId,
            sortKeyValue: `SortValue${uniqueContent}`,
        });
        await database.query(physicalId);
        await database.deleteItem({
            primaryKeyValue: physicalId,
            sortKeyValue: `SortValue${uniqueContent}`,
        });
    }
    async getResourceTable() {
        if (!this.resourceTable) {
            this.resourceTable = await dynamodb_1.CompositeStringIndexTable.fromExisting(this.dynamoDbClient, this.tableName);
        }
        return this.resourceTable;
    }
}
exports.DynamoBackedCustomResource = DynamoBackedCustomResource;
//# sourceMappingURL=data:application/json;base64,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