"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RQ_CONNECTION_ASSET = exports.REPO_DC_ASSET = exports.TEST_ASSET = exports.INSTALL_REPOSITORY_ASSET_LINUX = exports.CONFIG_WORKER_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_LINUX = exports.windowsDownloadRunScriptBoilerplate = exports.linuxDownloadRunScriptBoilerplate = exports.CWA_ASSET_WINDOWS = exports.CWA_ASSET_LINUX = void 0;
// TODO: Properly import from aws-rfdk. Not ideal
// to use a relative path here.
const assert_1 = require("@aws-cdk/assert");
const asset_constants_1 = require("../../core/test/asset-constants");
Object.defineProperty(exports, "CWA_ASSET_LINUX", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_LINUX; } });
Object.defineProperty(exports, "CWA_ASSET_WINDOWS", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_WINDOWS; } });
Object.defineProperty(exports, "linuxDownloadRunScriptBoilerplate", { enumerable: true, get: function () { return asset_constants_1.linuxDownloadRunScriptBoilerplate; } });
Object.defineProperty(exports, "windowsDownloadRunScriptBoilerplate", { enumerable: true, get: function () { return asset_constants_1.windowsDownloadRunScriptBoilerplate; } });
// configureWorker.sh
exports.CONFIG_WORKER_ASSET_LINUX = {
    Bucket: 'AssetParameterse90d5322c2b7457e7dbbacdfc3a350aa501f6a63b939475977f2464abb268b73S3Bucket1840D7FB',
    Key: 'AssetParameterse90d5322c2b7457e7dbbacdfc3a350aa501f6a63b939475977f2464abb268b73S3VersionKey7BA1309D',
};
// configureWorker.ps1
exports.CONFIG_WORKER_ASSET_WINDOWS = {
    Bucket: 'AssetParametersb1df82abec8605ca7a4666803d27eafda3bd66a9db0e5366d61cdf3d184af8b2S3BucketD9C14531',
    Key: 'AssetParametersb1df82abec8605ca7a4666803d27eafda3bd66a9db0e5366d61cdf3d184af8b2S3VersionKey40FA52FC',
};
// installDeadlineRepository.sh
exports.INSTALL_REPOSITORY_ASSET_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket8EB24E17'),
};
// test.file
exports.TEST_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket5D5509D9'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyF19FF080'),
};
// installRepostitoryDirectConnection
exports.REPO_DC_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket87338EBD'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyB7FF7B3C'),
};
exports.RQ_CONNECTION_ASSET = {
    Bucket: 'AssetParameters89a29e05a2a88ec4d4a02e847e3c3c9461d0154b326492f4cad655d4ca0bda98S3BucketC22E185C',
    Key: 'AssetParameters89a29e05a2a88ec4d4a02e847e3c3c9461d0154b326492f4cad655d4ca0bda98S3VersionKey0833D670',
};
//# sourceMappingURL=data:application/json;base64,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