"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowsDownloadRunScriptBoilerplate = exports.linuxDownloadRunScriptBoilerplate = exports.MONGODB_INSTANCE_3_6_SCRIPT = exports.INSTALL_MONGODB_3_6_SCRIPT_LINUX = exports.MOUNT_EBS_SCRIPT_LINUX = exports.CWA_ASSET_WINDOWS = exports.CWA_ASSET_LINUX = void 0;
const assert_1 = require("@aws-cdk/assert");
// ConfigureCloudWatchAgent.sh
exports.CWA_ASSET_LINUX = {
    Bucket: 'AssetParameters3793207e75b2a1b5dd4ebe458ab7a5cc20154224e846267d2c22da1d0631f94fS3Bucket352E624B',
    Key: 'AssetParameters3793207e75b2a1b5dd4ebe458ab7a5cc20154224e846267d2c22da1d0631f94fS3VersionKeyAE2B9691',
};
// ConfigureCloudWatchAgent.ps1
exports.CWA_ASSET_WINDOWS = {
    Bucket: 'AssetParameters05415690a7593cdde72555787eaac1d784dd3173e6083f23f83dc795bfe1741fS3Bucket0E53698F',
    Key: 'AssetParameters05415690a7593cdde72555787eaac1d784dd3173e6083f23f83dc795bfe1741fS3VersionKeyE92C9DEB',
};
// mountEbsBlockVolume.sh + metadataUtilities.sh + ec2-certificates.crt
exports.MOUNT_EBS_SCRIPT_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3BucketD23CD539'),
};
exports.INSTALL_MONGODB_3_6_SCRIPT_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3BucketAF54A815'),
};
exports.MONGODB_INSTANCE_3_6_SCRIPT = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket352E624B'),
};
function linuxDownloadRunScriptBoilerplate(script) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\')\naws s3 cp \'s3://',
        { Ref: script.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\' \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\'\n' +
            'set -e\n' +
            'chmod +x \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: script.Key,
                        },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\'\n\'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
    ];
}
exports.linuxDownloadRunScriptBoilerplate = linuxDownloadRunScriptBoilerplate;
function windowsDownloadRunScriptBoilerplate(script) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\' ) -ea 0\nRead-S3Object -BucketName \'',
        { Ref: script.Bucket },
        '\' -key \'',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\' -file \'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
        '\' -ErrorAction Stop\n&\'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: script.Key,
                        },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: script.Key },
                    ],
                },
            ],
        },
    ];
}
exports.windowsDownloadRunScriptBoilerplate = windowsDownloadRunScriptBoilerplate;
//# sourceMappingURL=data:application/json;base64,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