"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagConstruct = exports.RFDK_VERSION = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * The name of the tag used to associate the RFDK version and construct that deploys a given resources.
 */
const TAG_NAME = 'aws-rfdk';
/**
 * Function that reads in the version of RFDK from the `package.json` file.
 */
function getVersion() {
    return require(path.join(__dirname, '..', '..', '..', 'package.json')).version; // eslint-disable-line @typescript-eslint/no-require-imports
}
/**
 * The RFDK version string as listed in `package.json`
 */
exports.RFDK_VERSION = getVersion();
/**
 * Tags all resources deployed by a construct with the RFDK version and the construct name separated by a colon (":")
 * delimiter.
 *
 * @param scope A construct instance to tag
 */
function tagConstruct(scope) {
    // The constructor property is a reference to the "function" used to create
    const className = scope.constructor.name;
    const value = `${exports.RFDK_VERSION}:${className}`;
    core_1.Tags.of(scope).add(TAG_NAME, value);
}
exports.tagConstruct = tagConstruct;
//# sourceMappingURL=data:application/json;base64,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