import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::DLM::LifecyclePolicy`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 */
export interface CfnLifecyclePolicyProps {
    /**
     * `AWS::DLM::LifecyclePolicy.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description
     */
    readonly description?: string;
    /**
     * `AWS::DLM::LifecyclePolicy.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn
     */
    readonly executionRoleArn?: string;
    /**
     * `AWS::DLM::LifecyclePolicy.PolicyDetails`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails
     */
    readonly policyDetails?: CfnLifecyclePolicy.PolicyDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::DLM::LifecyclePolicy.State`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state
     */
    readonly state?: string;
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`
 *
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 */
export declare class CfnLifecyclePolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DLM::LifecyclePolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any): CfnLifecyclePolicy;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::DLM::LifecyclePolicy.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description
     */
    description: string | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn
     */
    executionRoleArn: string | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.PolicyDetails`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails
     */
    policyDetails: CfnLifecyclePolicy.PolicyDetailsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.State`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state
     */
    state: string | undefined;
    /**
     * Create a new `AWS::DLM::LifecyclePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLifecyclePolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html
     */
    interface CreateRuleProperty {
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.Interval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-interval
         */
        readonly interval: number;
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.IntervalUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-intervalunit
         */
        readonly intervalUnit: string;
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.Times`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-times
         */
        readonly times?: string[];
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html
     */
    interface CrossRegionCopyRetainRuleProperty {
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty.Interval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-interval
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty.IntervalUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-intervalunit
         */
        readonly intervalUnit?: string;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html
     */
    interface CrossRegionCopyRuleProperty {
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.CmkArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-cmkarn
         */
        readonly cmkArn?: string;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.CopyTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-copytags
         */
        readonly copyTags?: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.RetainRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-retainrule
         */
        readonly retainRule?: CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.TargetRegion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-targetregion
         */
        readonly targetRegion?: string;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html
     */
    interface FastRestoreRuleProperty {
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.AvailabilityZones`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-availabilityzones
         */
        readonly availabilityZones?: string[];
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.Count`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-count
         */
        readonly count?: number;
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.Interval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-interval
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.IntervalUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-intervalunit
         */
        readonly intervalUnit?: string;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html
     */
    interface ParametersProperty {
        /**
         * `CfnLifecyclePolicy.ParametersProperty.ExcludeBootVolume`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludebootvolume
         */
        readonly excludeBootVolume?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html
     */
    interface PolicyDetailsProperty {
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-parameters
         */
        readonly parameters?: CfnLifecyclePolicy.ParametersProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.PolicyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policytype
         */
        readonly policyType?: string;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.ResourceTypes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetypes
         */
        readonly resourceTypes: string[];
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.Schedules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-schedules
         */
        readonly schedules: Array<CfnLifecyclePolicy.ScheduleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.TargetTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-targettags
         */
        readonly targetTags: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html
     */
    interface RetainRuleProperty {
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.Count`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-count
         */
        readonly count?: number;
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.Interval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-interval
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.IntervalUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-intervalunit
         */
        readonly intervalUnit?: string;
    }
}
export declare namespace CfnLifecyclePolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CopyTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-copytags
         */
        readonly copyTags?: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CreateRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-createrule
         */
        readonly createRule?: CfnLifecyclePolicy.CreateRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CrossRegionCopyRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-crossregioncopyrules
         */
        readonly crossRegionCopyRules?: Array<CfnLifecyclePolicy.CrossRegionCopyRuleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.FastRestoreRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-fastrestorerule
         */
        readonly fastRestoreRule?: CfnLifecyclePolicy.FastRestoreRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-name
         */
        readonly name?: string;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.RetainRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-retainrule
         */
        readonly retainRule?: CfnLifecyclePolicy.RetainRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.TagsToAdd`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-tagstoadd
         */
        readonly tagsToAdd?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.VariableTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-variabletags
         */
        readonly variableTags?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
