/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.ugraphic.UChange;

public class UTranslate
implements UChange {
    private final double dx;
    private final double dy;

    public String toString() {
        return "translate dx=" + this.dx + " dy=" + this.dy;
    }

    public static UTranslate none() {
        return new UTranslate(0.0, 0.0);
    }

    public UTranslate(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public static UTranslate dx(double dx) {
        return new UTranslate(dx, 0.0);
    }

    public static UTranslate dy(double dy) {
        return new UTranslate(0.0, dy);
    }

    public UTranslate(XPoint2D p) {
        this(p.getX(), p.getY());
    }

    public UTranslate() {
        this(0.0, 0.0);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public boolean isAlmostSame(UTranslate other) {
        return this.dx == other.dx || this.dy == other.dy;
    }

    public XPoint2D getTranslated(XPoint2D p) {
        if (p == null) {
            return null;
        }
        return new XPoint2D(p.getX() + this.dx, p.getY() + this.dy);
    }

    public XDimension2D getTranslated(XDimension2D dim) {
        return new XDimension2D(dim.getWidth() + this.dx, dim.getHeight() + this.dy);
    }

    public UTranslate scaled(double scale) {
        return new UTranslate(this.dx * scale, this.dy * scale);
    }

    public UTranslate compose(UTranslate other) {
        return new UTranslate(this.dx + other.dx, this.dy + other.dy);
    }

    public UTranslate reverse() {
        return new UTranslate(-this.dx, -this.dy);
    }

    public XRectangle2D apply(XRectangle2D rect) {
        return new XRectangle2D(rect.getX() + this.dx, rect.getY() + this.dy, rect.getWidth(), rect.getHeight());
    }

    public UTranslate multiplyBy(double v) {
        return new UTranslate(this.dx * v, this.dy * v);
    }

    public UTranslate sym() {
        return new UTranslate(this.dy, this.dx);
    }

    public XPoint2D getPosition() {
        return new XPoint2D(this.dx, this.dy);
    }
}

