/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Value;

public class StyleBuilder
implements AutomaticCounter {
    private final Map<StyleSignatureBasic, Style> stylesMap = new LinkedHashMap<StyleSignatureBasic, Style>();
    private final Set<StyleSignatureBasic> printedForLog;
    private final SkinParam skinParam;
    private int counter;

    public void printMe() {
        for (Map.Entry<StyleSignatureBasic, Style> ent : this.stylesMap.entrySet()) {
            ent.getValue().printMe();
        }
    }

    private StyleBuilder(SkinParam skinParam, Set<StyleSignatureBasic> printedForLog) {
        this.skinParam = skinParam;
        this.printedForLog = new LinkedHashSet<StyleSignatureBasic>();
    }

    public StyleBuilder(SkinParam skinParam) {
        this(skinParam, new LinkedHashSet<StyleSignatureBasic>());
    }

    public final SkinParam getSkinParam() {
        return this.skinParam;
    }

    public Style createStyle(String name) {
        if (name.contains("*")) {
            throw new IllegalArgumentException();
        }
        StyleSignatureBasic signature = new StyleSignatureBasic(name = name.toLowerCase());
        Style result = this.stylesMap.get(signature);
        if (result == null) {
            return new Style(signature, new EnumMap<PName, Value>(PName.class));
        }
        return result;
    }

    public StyleBuilder muteStyle(Style modifiedStyle) {
        LinkedHashMap<StyleSignatureBasic, Style> copy = new LinkedHashMap<StyleSignatureBasic, Style>(this.stylesMap);
        StyleSignatureBasic signature = modifiedStyle.getSignature();
        Style orig = (Style)copy.get(signature);
        if (orig == null) {
            copy.put(signature, modifiedStyle);
        } else {
            Style tmp = orig.mergeWith(modifiedStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            copy.put(signature, tmp);
        }
        StyleBuilder result = new StyleBuilder(this.skinParam, this.printedForLog);
        result.stylesMap.putAll(copy);
        result.counter = this.counter;
        return result;
    }

    public void loadInternal(StyleSignatureBasic signature, Style newStyle) {
        if (signature.isStarred()) {
            throw new IllegalArgumentException();
        }
        Style orig = this.stylesMap.get(signature);
        if (orig == null) {
            this.stylesMap.put(signature, newStyle);
        } else {
            Style tmp = orig.mergeWith(newStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            this.stylesMap.put(signature, tmp);
        }
    }

    @Override
    public int getNextInt() {
        return ++this.counter;
    }

    public Style getMergedStyle(StyleSignatureBasic signature) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info("Using style " + signature);
        }
        Style result = null;
        for (Map.Entry<StyleSignatureBasic, Style> ent : this.stylesMap.entrySet()) {
            StyleSignatureBasic key = ent.getKey();
            if (!key.matchAll(signature)) continue;
            if (result == null) {
                result = ent.getValue();
                continue;
            }
            result = result.mergeWith(ent.getValue(), MergeStrategy.OVERWRITE_EXISTING_VALUE);
        }
        return result;
    }

    public Style getMergedStyleSpecial(StyleSignatureBasic signature, int deltaPriority) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info("Using style " + signature);
        }
        Style result = null;
        for (Map.Entry<StyleSignatureBasic, Style> ent : this.stylesMap.entrySet()) {
            StyleSignatureBasic key = ent.getKey();
            if (!key.matchAll(signature)) continue;
            Style tmp = ent.getValue();
            if (key.isStarred()) {
                tmp = tmp.deltaPriority(deltaPriority);
            }
            if (result == null) {
                result = tmp;
                continue;
            }
            result = result.mergeWith(tmp, MergeStrategy.OVERWRITE_EXISTING_VALUE);
        }
        return result;
    }
}

