/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DividerTile
extends AbstractTile
implements Tile {
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Divider divider;
    private final Real xorigin;
    private final TileArguments tileArguments;
    private final YGauge yGauge;

    @Override
    public Event getEvent() {
        return this.divider;
    }

    public DividerTile(Divider divider, TileArguments tileArguments, YGauge currentY) {
        super(tileArguments.getStringBounder(), currentY);
        this.tileArguments = tileArguments;
        this.divider = divider;
        this.skin = tileArguments.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        this.xorigin = tileArguments.getXOrigin();
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.divider.getUsedStyles(), ComponentType.DIVIDER, null, this.skinParam, this.divider.getText());
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = Area.create(this.tileArguments.getBorder2() - this.tileArguments.getBorder1() - this.xorigin.getCurrentValue(), dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.tileArguments.getBorder1()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        return this.xorigin;
    }

    @Override
    public Real getMaxX() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return this.xorigin.addFixed(dim.getWidth());
    }
}

