/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.emoji.SvgNanoParser;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandSpriteSvgMultiline
extends CommandMultilines2<TitledDiagram> {
    public CommandSpriteSvgMultiline() {
        super(CommandSpriteSvgMultiline.getRegexConcat(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteSvgMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([-%pLN_]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("SVGSTART", "(\\<svg\\b.*)"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "(.*\\</svg\\>)$";
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram system, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String svgStart = line0.get("SVGSTART", 0);
        lines = lines.subExtract(1, 0);
        StringBuilder svg = new StringBuilder(svgStart);
        for (StringLocated sl : lines) {
            svg.append(sl.getString());
        }
        SvgNanoParser nanoParser = new SvgNanoParser(svg.toString(), true);
        system.addSprite(line0.get("NAME", 0), nanoParser);
        return CommandExecutionResult.ok();
    }
}

