/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtileRoot;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInsideLabelled;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileHexagonInside
extends AbstractGtile {
    protected final HColor backColor;
    protected final HColor borderColor;
    protected final TextBlock label;
    protected final XDimension2D dimLabel;
    protected final double shadowing;

    public final StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public GtileHexagonInsideLabelled withEastLabel(TextBlock eastLabel) {
        return new GtileHexagonInsideLabelled(this, TextBlockUtils.EMPTY_TEXT_BLOCK, eastLabel, TextBlockUtils.EMPTY_TEXT_BLOCK);
    }

    public GtileHexagonInsideLabelled withWestLabel(TextBlock westLabel) {
        return new GtileHexagonInsideLabelled(this, TextBlockUtils.EMPTY_TEXT_BLOCK, TextBlockUtils.EMPTY_TEXT_BLOCK, westLabel);
    }

    public AbstractGtileRoot withSouthLabel(TextBlock southLabel) {
        return new GtileHexagonInsideLabelled(this, southLabel, TextBlockUtils.EMPTY_TEXT_BLOCK, TextBlockUtils.EMPTY_TEXT_BLOCK);
    }

    public GtileHexagonInside(StringBounder stringBounder, TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane) {
        super(stringBounder, skinParam, swimlane);
        Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.label = label;
        this.dimLabel = label.calculateDimension(stringBounder);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.dimLabel.getWidth() == 0.0 || this.dimLabel.getHeight() == 0.0 ? new XDimension2D(24.0, 24.0) : this.dimLabel.atLeast(24.0, 24.0).delta(24.0, 0.0);
        return dim;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        ug = ug.apply(this.borderColor).apply(this.getThickness()).apply(this.backColor.bg());
        ug.draw(Hexagon.asPolygon(this.shadowing, dimTotal.getWidth(), dimTotal.getHeight()));
        double lx = (dimTotal.getWidth() - this.dimLabel.getWidth()) / 2.0;
        double ly = (dimTotal.getHeight() - this.dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
    }
}

