"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 *  Defines listener for a VirtualNode
 */
class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode
     */
    static http(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualNode
     */
    static http2(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_Http2VirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an GRPC Listener for a VirtualNode
     */
    static grpc(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an TCP Listener for a VirtualNode
     */
    static tcp(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.172.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tls, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tls = tls;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck?.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: utils_1.renderListenerTlsOptions(scope, this.tls),
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: timeout?.idle !== undefined ? {
                    unit: 'ms',
                    value: timeout?.idle.toMilliseconds(),
                } : undefined,
                perRequest: timeout?.perRequest !== undefined ? {
                    unit: 'ms',
                    value: timeout?.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: connectionPool?.maxRequests !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: connectionPool?.maxConnections !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: connectionPool?.maxPendingRequests !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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