"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsMode = void 0;
/**
 * Enum of supported TLS modes
 */
var TlsMode;
(function (TlsMode) {
    /**
     * Only accept encrypted traffic
     */
    TlsMode["STRICT"] = "STRICT";
    /**
     * Accept encrypted and plaintext traffic.
     */
    TlsMode["PERMISSIVE"] = "PERMISSIVE";
    /**
     * TLS is disabled, only accept plaintext traffic.
     */
    TlsMode["DISABLED"] = "DISABLED";
})(TlsMode = exports.TlsMode || (exports.TlsMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItdGxzLW9wdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci10bHMtb3B0aW9ucy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHQTs7R0FFRztBQUNILElBQVksT0FlWDtBQWZELFdBQVksT0FBTztJQUNqQjs7T0FFRztJQUNILDRCQUFpQixDQUFBO0lBRWpCOztPQUVHO0lBQ0gsb0NBQXlCLENBQUE7SUFFekI7O09BRUc7SUFDSCxnQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBZlcsT0FBTyxHQUFQLGVBQU8sS0FBUCxlQUFPLFFBZWxCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGxzQ2VydGlmaWNhdGUgfSBmcm9tICcuL3Rscy1jZXJ0aWZpY2F0ZSc7XG5pbXBvcnQgeyBNdXR1YWxUbHNWYWxpZGF0aW9uIH0gZnJvbSAnLi90bHMtdmFsaWRhdGlvbic7XG5cbi8qKlxuICogRW51bSBvZiBzdXBwb3J0ZWQgVExTIG1vZGVzXG4gKi9cbmV4cG9ydCBlbnVtIFRsc01vZGUge1xuICAvKipcbiAgICogT25seSBhY2NlcHQgZW5jcnlwdGVkIHRyYWZmaWNcbiAgICovXG4gIFNUUklDVCA9ICdTVFJJQ1QnLFxuXG4gIC8qKlxuICAgKiBBY2NlcHQgZW5jcnlwdGVkIGFuZCBwbGFpbnRleHQgdHJhZmZpYy5cbiAgICovXG4gIFBFUk1JU1NJVkUgPSAnUEVSTUlTU0lWRScsXG5cbiAgLyoqXG4gICAqIFRMUyBpcyBkaXNhYmxlZCwgb25seSBhY2NlcHQgcGxhaW50ZXh0IHRyYWZmaWMuXG4gICAqL1xuICBESVNBQkxFRCA9ICdESVNBQkxFRCcsXG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBUTFMgcHJvcGVydGllcyBmb3IgbGlzdGVuZXJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMaXN0ZW5lclRsc09wdGlvbnMge1xuICAvKipcbiAgICogUmVwcmVzZW50cyBUTFMgY2VydGlmaWNhdGVcbiAgICovXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlOiBUbHNDZXJ0aWZpY2F0ZTtcblxuICAvKipcbiAgICogVGhlIFRMUyBtb2RlLlxuICAgKi9cbiAgcmVhZG9ubHkgbW9kZTogVGxzTW9kZTtcblxuICAvKipcbiAgICogUmVwcmVzZW50cyBhIGxpc3RlbmVyJ3MgVExTIHZhbGlkYXRpb24gY29udGV4dC5cbiAgICogVGhlIGNsaWVudCBjZXJ0aWZpY2F0ZSB3aWxsIG9ubHkgYmUgdmFsaWRhdGVkIGlmIHRoZSBjbGllbnQgcHJvdmlkZXMgaXQsIGVuYWJsaW5nIG11dHVhbCBUTFMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gY2xpZW50IFRMUyBjZXJ0aWZpY2F0ZSBpcyBub3QgcmVxdWlyZWRcbiAgICovXG4gIHJlYWRvbmx5IG11dHVhbFRsc1ZhbGlkYXRpb24/OiBNdXR1YWxUbHNWYWxpZGF0aW9uO1xufVxuIl19