# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['remagic']

package_data = \
{'': ['*']}

extras_require = \
{':extra == "regex"': ['regex>=2022.9.13,<2023.0.0'],
 ':python_version < "3.8"': ['importlib_metadata>=4.5.0,<5.0.0']}

setup_kwargs = {
    'name': 'remagic',
    'version': '0.1.2a0',
    'description': 'Working with RegEx made easy!',
    'long_description': '[![Coverage Status](https://coveralls.io/repos/github/ificiana/remagic/badge.svg?branch=main)](https://coveralls.io/github/ificiana/remagic?branch=main)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/remagic)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/remagic)\n![PyPI - License](https://img.shields.io/pypi/l/remagic)\n\n# remagic\n\nWorking with regex made easier!\nPartly inspired from `magic-regexp` for Node\n\n```py\nfrom remagic import *\n\npattern1 = create(DIGIT)  # matches any digit\npattern2 = char_in("aeiou")  # matches any char in "aeiou"\npattern3 = ~pattern2  # negates the pattern in pattern2, \n# i.e. match everything except characters in "aeiou"\n# Note: remagic 0.1.1 doesn\'t support the ~ syntax\n# use char_not_in("aeiou") instead\npattern4 = pattern1 + pattern3\n# finally compile, use standard flags as optional argument\nR = pattern4.compile()\n# use the regex later\n``` \n\n## Installation\n\nInstall from PyPI:\n`pip install remagic`\n\n## Work in Progress!\n\n### Documentation\n\nTODO: [docs](https://ificiana.github.io/remagic)\n\n### Known bugs\n\n- improper behaviour with `any_of`\n',
    'author': 'Ificiana',
    'author_email': 'ificiana@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ificiana/remagic',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.7.2,<4.0.0',
}


setup(**setup_kwargs)
