__all__=['', 'WinHelp', 'HH_AKLINK', 'HH_FTS_QUERY', 'HH_POPUP', 'HH_WINTYPE', 'NMHDR', 'HHN_NOTIFY', 'HHNTRACK', 'HtmlHelp', 'debug', 'HH_ALINK_LOOKUP', 'HH_CLOSE_ALL', 'HH_DISPLAY_INDEX', 'HH_DISPLAY_SEARCH', 'HH_DISPLAY_TEXT_POPUP', 'HH_DISPLAY_TOC', 'HH_DISPLAY_TOPIC', 'HH_ENUM_CATEGORY', 'HH_ENUM_CATEGORY_IT', 'HH_ENUM_INFO_TYPE', 'HH_FTS_DEFAULT_PROXIMITY', 'HH_GET_LAST_ERROR', 'HH_GET_WIN_HANDLE', 'HH_GET_WIN_TYPE', 'HH_GPROPID_CONTENT_LANGUAGE', 'HH_GPROPID_CURRENT_SUBSET', 'HH_GPROPID_SINGLETHREAD', 'HH_GPROPID_TOOLBAR_MARGIN', 'HH_GPROPID_UI_LANGUAGE', 'HH_HELP_CONTEXT', 'HH_HELP_FINDER', 'HH_INITIALIZE', 'HH_KEYWORD_LOOKUP', 'HH_MAX_TABS_CUSTOM', 'HH_PRETRANSLATEMESSAGE', 'HH_RESERVED1', 'HH_RESERVED2', 'HH_RESERVED3', 'HH_RESET_IT_FILTER', 'HH_SET_EXCLUSIVE_FILTER', 'HH_SET_GLOBAL_PROPERTY', 'HH_SET_INCLUSIVE_FILTER', 'HH_SET_INFO_TYPE', 'HH_SET_WIN_TYPE', 'HH_SYNC', 'HH_TAB_AUTHOR', 'HH_TAB_CONTENTS', 'HH_TAB_CUSTOM_FIRST', 'HH_TAB_CUSTOM_LAST', 'HH_TAB_FAVORITES', 'HH_TAB_HISTORY', 'HH_TAB_INDEX', 'HH_TAB_SEARCH', 'HH_TP_HELP_CONTEXTMENU', 'HH_TP_HELP_WM_HELP', 'HH_UNINITIALIZE', 'HHACT_BACK', 'HHACT_CONTRACT', 'HHACT_CUSTOMIZE', 'HHACT_EXPAND', 'HHACT_FORWARD', 'HHACT_HIGHLIGHT', 'HHACT_HOME', 'HHACT_JUMP1', 'HHACT_JUMP2', 'HHACT_LAST_ENUM', 'HHACT_NOTES', 'HHACT_OPTIONS', 'HHACT_PRINT', 'HHACT_REFRESH', 'HHACT_STOP', 'HHACT_SYNC', 'HHACT_TAB_CONTENTS', 'HHACT_TAB_FAVORITES', 'HHACT_TAB_HISTORY', 'HHACT_TAB_INDEX', 'HHACT_TAB_SEARCH', 'HHACT_TOC_NEXT', 'HHACT_TOC_PREV', 'HHACT_ZOOM', 'HHN_FIRST', 'HHN_LAST', 'HHN_NAVCOMPLETE', 'HHN_TRACK', 'HHN_WINDOW_CREATE', 'HHWIN_BUTTON_BACK', 'HHWIN_BUTTON_BROWSE_BCK', 'HHWIN_BUTTON_BROWSE_FWD', 'HHWIN_BUTTON_CONTENTS', 'HHWIN_BUTTON_EXPAND', 'HHWIN_BUTTON_FAVORITES', 'HHWIN_BUTTON_FORWARD', 'HHWIN_BUTTON_HISTORY', 'HHWIN_BUTTON_HOME', 'HHWIN_BUTTON_INDEX', 'HHWIN_BUTTON_JUMP1', 'HHWIN_BUTTON_JUMP2', 'HHWIN_BUTTON_NOTES', 'HHWIN_BUTTON_OPTIONS', 'HHWIN_BUTTON_PRINT', 'HHWIN_BUTTON_REFRESH', 'HHWIN_BUTTON_SEARCH', 'HHWIN_BUTTON_STOP', 'HHWIN_BUTTON_SYNC', 'HHWIN_BUTTON_TOC_NEXT', 'HHWIN_BUTTON_TOC_PREV', 'HHWIN_BUTTON_ZOOM', 'HHWIN_DEF_BUTTONS', 'HHWIN_NAVTAB_BOTTOM', 'HHWIN_NAVTAB_LEFT', 'HHWIN_NAVTAB_TOP', 'HHWIN_PARAM_CUR_TAB', 'HHWIN_PARAM_EXPANSION', 'HHWIN_PARAM_EXSTYLES', 'HHWIN_PARAM_HISTORY_COUNT', 'HHWIN_PARAM_INFOTYPES', 'HHWIN_PARAM_NAV_WIDTH', 'HHWIN_PARAM_PROPERTIES', 'HHWIN_PARAM_RECT', 'HHWIN_PARAM_SHOWSTATE', 'HHWIN_PARAM_STYLES', 'HHWIN_PARAM_TABORDER', 'HHWIN_PARAM_TABPOS', 'HHWIN_PARAM_TB_FLAGS', 'HHWIN_PROP_AUTO_SYNC', 'HHWIN_PROP_CHANGE_TITLE', 'HHWIN_PROP_MENU', 'HHWIN_PROP_NAV_ONLY_WIN', 'HHWIN_PROP_NO_TOOLBAR', 'HHWIN_PROP_NODEF_EXSTYLES', 'HHWIN_PROP_NODEF_STYLES', 'HHWIN_PROP_NOTB_TEXT', 'HHWIN_PROP_NOTITLEBAR', 'HHWIN_PROP_ONTOP', 'HHWIN_PROP_POST_QUIT', 'HHWIN_PROP_TAB_ADVSEARCH', 'HHWIN_PROP_TAB_AUTOHIDESHOW', 'HHWIN_PROP_TAB_CUSTOM1', 'HHWIN_PROP_TAB_CUSTOM2', 'HHWIN_PROP_TAB_CUSTOM3', 'HHWIN_PROP_TAB_CUSTOM4', 'HHWIN_PROP_TAB_CUSTOM5', 'HHWIN_PROP_TAB_CUSTOM6', 'HHWIN_PROP_TAB_CUSTOM7', 'HHWIN_PROP_TAB_CUSTOM8', 'HHWIN_PROP_TAB_CUSTOM9', 'HHWIN_PROP_TAB_FAVORITES', 'HHWIN_PROP_TAB_HISTORY', 'HHWIN_PROP_TAB_SEARCH', 'HHWIN_PROP_TRACKING', 'HHWIN_PROP_TRI_PANE', 'HHWIN_PROP_USER_POS', 'HHWIN_TB_MARGIN', 'IDTB_BACK', 'IDTB_BROWSE_BACK', 'IDTB_BROWSE_FWD', 'IDTB_CONTENTS', 'IDTB_CONTRACT', 'IDTB_CUSTOMIZE', 'IDTB_EXPAND', 'IDTB_FAVORITES', 'IDTB_FORWARD', 'IDTB_HISTORY', 'IDTB_HOME', 'IDTB_INDEX', 'IDTB_JUMP1', 'IDTB_JUMP2', 'IDTB_NOTES', 'IDTB_OPTIONS', 'IDTB_PRINT', 'IDTB_REFRESH', 'IDTB_SEARCH', 'IDTB_STOP', 'IDTB_SYNC', 'IDTB_TOC_NEXT', 'IDTB_TOC_PREV', 'IDTB_ZOOM']
from typing import *
from win32helper.win32typing import *
"""A module, encapsulating the Win32 help API's."""


def WinHelp(hwnd:'int',hlpFile:'str',cmd:'int',data:'Union[None, int, str]'=None) -> 'None':
    """
    Invokes the Windows Help system.

Args:

      hwnd(int):The handle of the window requesting help.
      hlpFile(str):The name of the help file.
      cmd(int):The type of help.  See the api for full details.
      data(Union[None, int, str]):Additional data specific to the help call. Can be a buffer or pointer-sized int.Win32 API References

Returns:

      None:Search for WinHelp at msdn, google or google groups.
Return ValueThe method raises an exception if an error occurs.

        
    """
    pass
        

def HH_AKLINK() -> 'PyHH_AKLINK':
    """
    Creates a new HH_AKLINK object.

Args:



Returns:

      PyHH_AKLINK
        
    """
    pass
        

def HH_FTS_QUERY() -> 'PyHH_FTS_QUERY':
    """
    Creates a new HH_FTS_QUERY object.

Args:



Returns:

      PyHH_FTS_QUERY
        
    """
    pass
        

def HH_POPUP() -> 'PyHH_POPUP':
    """
    Creates a new HH_POPUP object.

Args:



Returns:

      PyHH_POPUP
        
    """
    pass
        

def HH_WINTYPE() -> 'PyHH_WINTYPE':
    """
    Creates a new HH_WINTYPE object.

Args:



Returns:

      PyHH_WINTYPE
        
    """
    pass
        

def NMHDR() -> 'PyNMHDR':
    """
    Creates a new NMHDR object.

Args:



Returns:

      PyNMHDR
        
    """
    pass
        

def HHN_NOTIFY() -> 'PyHHN_NOTIFY':
    """
    Creates a new HHN_NOTIFY object.

Args:



Returns:

      PyHHN_NOTIFY
        
    """
    pass
        

def HHNTRACK() -> 'PyHHNTRACK':
    """
    Creates a new HHNTRACK object.

Args:



Returns:

      PyHHNTRACK
        
    """
    pass
        

def HtmlHelp(hwnd:'int',file:'Union[None, str]',cmd:'int',data:'Union[None, Any, Tuple[int], int, str]'=0) -> 'int':
    """
    Invokes the Windows Html Help system.

Args:

      hwnd(int):The handle of the window requesting help.
      file(Union[None, str]):The name of the help file, or None.
      cmd(int):The type of help.  Valid values are:HH_ALINK_LOOKUP: Looks up one or more Associative link (ALink) names in a compiled help (.chm) file. The ALink names to search for, and the action to be taken if no matches are found, are specified in the win32help::HH_AKLINK structure.file: Specifies a compiled help (.chm) file, or a specific topic within a compiled help file.data: Specifies NULL or a pointer to a topic within a compiled help file.HH_CLOSE_ALL: Closes all windows opened directly or indirectly by the calling program.  The args are not checked for type, values are set as they "Must" be.hwnd: Must be None.file: Must be None.data: Must be zero.HH_DISPLAY_INDEX: Selects the Index tab in the Navigation pane of the HTML Help Viewer and searches for the keyword specified in the data parameter.file: Specifies a compiled help (.chm) file, or a specific topic within a compiled help file.data: Specifies the keyword to select in the index (.hhk) file.HH_DISPLAY_SEARCH: Selects the Search tab in the Navigation pane of the HTML Help Viewer and performs a search for the term specified in the searchQuery parameter of the win32help::HH_FTS_QUERY structure.file: Specifies a compiled help (.chm) file, or a specific topic within a compiled help file.data: Specifies a pointer to an win32help::HH_FTS_QUERY structure.HH_DISPLAY_TEXT_POPUP: Opens a pop-up window that displays the contents of one of the following: An explicit text string. A text string based on a resource ID. A text string ID based on a text file contained in a compiled help (.chm) file.file: To use an explicit text string, use None.  To use a text string from a resource, use None. To use text string from a text file contained in a compiled help file, specify the .chm file and the text file within the .chm file.data: Specifies a pointer to an win32help::HH_POPUP structure. HH_DISPLAY_TOC: Selects the Contents tab in the Navigation pane of the HTML Help Viewer.file: Specifies a compiled help (.chm) file, or a specific topic within a compiled help file.data: Specifies None or a pointer to a topic within a compiled help file.HH_DISPLAY_TOPIC: Opens a help topic in a specified help window. If a window type is not specified, a default window type is used. If the window type or default window type is open, the help topic replaces the current topic in the window.file: Specifies a compiled help (.chm) file, or a specific topic within a compiled help file. To specify a defined window type, insert a greater-than (&gt) character followed by the name of the window type.data: Specifies None or a pointer to a topic within a compiled help file.HH_GET_LAST_ERROR: Returns information about the last error that occurred in the HTML Help ActiveX control (Hhctrl.ocx).file: Must be Nonedata: A pointer to a HH_LAST_ERROR structure.Has not been implemented by Microsoft yetHH_GET_WIN_HANDLE: Returns the handle (hwnd) of a specified window type.file: Specifies the name of the compiled help (.chm) file in which the window type is defined.data: Specifies the name of the window type whose handle you want to return.HH_GET_WIN_TYPE: Retrieves a pointer to the win32help::HH_WINTYPE structure associated with a specified window type.file: Specifies the name of the window type whose information you want to get and the name of the compiled help (.chm) file in which the window type is defined. The window name must begin with a greater-than (&gt) character and must be preceded by the name of the compiled help file it is defined in.data: Ignored.HH_HELP_CONTEXT: Displays a help topic based on a mapped topic ID. If a window type is not specified, a default window type is used. If the window type or default window type is open, the help topic replaces the current topic in the window.file: Specifies the compiled help (.chm) file that contains the mapping information. To specify a defined window type, insert a greater-than (&gt) character followed by the name of the window type.data: Specifies the numeric ID of the topic to display. You must map symbolic IDs of dialog boxes to numeric IDs in the [MAP] section of your project (.hhp) file.HH_INITIALIZE: This command initializes the help system for use and must be the first HTML Help command called. It returns a cookie which must be used in the HH_UNINITIALIZE call. HH_INITIALIZE configures HTML Help to run on the same thread as the calling application instead of a secondary thread by setting the global property HH_GPROPID_SINGLETHREAD to VARIANT_TRUE. Running HTML Help on the same thread as the calling application requires the calling application to send messages to HTML Help by calling the HH_PRETRANSLATEMESSAGE command.file: Must be None.data: Ignored.HH_KEYWORD_LOOKUP: Looks up one or more keywords in a compiled help (.chm) file. The keywords to search for and the action to be taken if no matches are found are specified in the win32help::HH_AKLINK structure.file: Specifies the compiled help (.chm) file that contains keywords.data: Points to an win32help::HH_AKLINK structure.HH_PRETRANSLATEMESSAGE: This command is called in the message loop of your Windows application to ensure proper handling of Windows messages, especially keyboard messages when running HTML Help single thread. The HTML Help API is not thread safe and must be called from one and only one thread in a process.filedata: Points to a Win32 MSG structure.Has not been implemented yetHH_SET_WIN_TYPE: Creates a new help window or modifies an existing help window at run time.file: Specifies the name of the window type that you want to create or modify and the name of the compiled help (.chm) file in which the window type is defined. The window type name must begin with a greater-than (&gt) character and must be preceded by the name of the compiled help file in which it is defined.data: Points to an win32help::HH_WINTYPE structure.HH_SYNC: Locates and selects the contents entry for the help topic that is open in the Topic pane of the HTML Help Viewer.file: Specifies the name of the window type that you want to sync and the name of the compiled help (.chm) file in which the window type is defined. The window type name must begin with a greater-than (&gt) character and must be preceded by the name of the compiled help file in which it is defined.data: Specifies a pointer to a topic within a compiled help file. This value is the topic file to which the contents will synchronize.HH_TP_HELP_CONTEXTMENU: Opens a pop-up context menu. Generally used in response to the Windows WM_CONTEXTMENU message. For example, this message is sent when a user right-clicks a dialog box control.hwnd: Specifies the window handle of the dialog box control for which you want pop-up help to appear. This is typically the control that has focus. file: Specifies the compiled help (.chm) file, and the text file that contains the pop-up help topics. By default, the text file is named Cshelp.txt. If Cshelp.txt is located in the root of the compiled help file, then you only need to specify the help file name. If not, you must also specify the relative path.data: Specifies an array of DWORDs containing pairs of dialog box control IDs and help topic IDs. The array must be terminated by zero, as in the following example: DWORD ids[3]; ids[0] = ControlId; ids[1] = HelpId; ids[2] = 0;HH_TP_HELP_WM_HELP: Opens a pop-up help topic. Generally used in response to the Windows WM_HELP message. For example, this message is sent when a user presses F1.hwnd: Specifies the window handle of the dialog box control for which you want pop-up help to appear. This is typically the control that has focus. file: Specifies the compiled help (.chm) file, and the text file that contains the pop-up help topics. By default, the text file is named Cshelp.txt. If Cshelp.txt is located in the root of the compiled help file, then you only need to specify the help file name. If not, you must also specify the relative path.data: Specifies an array of DWORDs containing pairs of dialog box control IDs and help topic IDs. The array must be terminated by 0, as in the following example: DWORD ids[3]; ids[0] = ControlId; ids[1] = HelpId; ids[2] = 0;HH_UNINITIALIZE: This command is called to properly shut down HTML Help. This function should be the last help command the application calls. HH_UNINITIALIZE should not be called during DLL process detach, but during the normal application shutdown process.  The type of the file arg is not checked, just set to the value it "Must" be.file: Must be None.data: Specifies a cookie. This is the cookie returned by HH_INITIALIZE. 
      data(Union[None, Any, Tuple[int], int, str]):Additional data specific to the help call.Win32 API References

Returns:

      int:Search for HtmlHelp at msdn, google or google groups.
Return ValueDepending on the specified cmd and the result:

HH_GET_WIN_TYPE



: 

tuple: (hwnd as below, and the win32help::HH_WINTYPE object). 

Deep copy the structure to which dwData points before modifying the 

structure.

HH_INITIALIZE



: 

tuple: (hwnd as below, and the cookie). 

This call returns a cookie that you must pass as the value of 

data when you call HH_UNINITIALIZE



.


All other commands



:
 

HtmlHelp() returns one or both of the following: 

The handle (hwnd) of the help window. 

NULL. In some cases, NULL indicates failure; in other cases, NULL 

indicates that the help window has not yet been created.

        
    """
    pass
        
debug = ...
HH_ALINK_LOOKUP = ...
HH_CLOSE_ALL = ...
HH_DISPLAY_INDEX = ...
HH_DISPLAY_SEARCH = ...
HH_DISPLAY_TEXT_POPUP = ...
HH_DISPLAY_TOC = ...
HH_DISPLAY_TOPIC = ...
HH_ENUM_CATEGORY = ...
HH_ENUM_CATEGORY_IT = ...
HH_ENUM_INFO_TYPE = ...
HH_FTS_DEFAULT_PROXIMITY = ...
HH_GET_LAST_ERROR = ...
HH_GET_WIN_HANDLE = ...
HH_GET_WIN_TYPE = ...
HH_GPROPID_CONTENT_LANGUAGE = ...
HH_GPROPID_CURRENT_SUBSET = ...
HH_GPROPID_SINGLETHREAD = ...
HH_GPROPID_TOOLBAR_MARGIN = ...
HH_GPROPID_UI_LANGUAGE = ...
HH_HELP_CONTEXT = ...
HH_HELP_FINDER = ...
HH_INITIALIZE = ...
HH_KEYWORD_LOOKUP = ...
HH_MAX_TABS_CUSTOM = ...
HH_PRETRANSLATEMESSAGE = ...
HH_RESERVED1 = ...
HH_RESERVED2 = ...
HH_RESERVED3 = ...
HH_RESET_IT_FILTER = ...
HH_SET_EXCLUSIVE_FILTER = ...
HH_SET_GLOBAL_PROPERTY = ...
HH_SET_INCLUSIVE_FILTER = ...
HH_SET_INFO_TYPE = ...
HH_SET_WIN_TYPE = ...
HH_SYNC = ...
HH_TAB_AUTHOR = ...
HH_TAB_CONTENTS = ...
HH_TAB_CUSTOM_FIRST = ...
HH_TAB_CUSTOM_LAST = ...
HH_TAB_FAVORITES = ...
HH_TAB_HISTORY = ...
HH_TAB_INDEX = ...
HH_TAB_SEARCH = ...
HH_TP_HELP_CONTEXTMENU = ...
HH_TP_HELP_WM_HELP = ...
HH_UNINITIALIZE = ...
HHACT_BACK = ...
HHACT_CONTRACT = ...
HHACT_CUSTOMIZE = ...
HHACT_EXPAND = ...
HHACT_FORWARD = ...
HHACT_HIGHLIGHT = ...
HHACT_HOME = ...
HHACT_JUMP1 = ...
HHACT_JUMP2 = ...
HHACT_LAST_ENUM = ...
HHACT_NOTES = ...
HHACT_OPTIONS = ...
HHACT_PRINT = ...
HHACT_REFRESH = ...
HHACT_STOP = ...
HHACT_SYNC = ...
HHACT_TAB_CONTENTS = ...
HHACT_TAB_FAVORITES = ...
HHACT_TAB_HISTORY = ...
HHACT_TAB_INDEX = ...
HHACT_TAB_SEARCH = ...
HHACT_TOC_NEXT = ...
HHACT_TOC_PREV = ...
HHACT_ZOOM = ...
HHN_FIRST = ...
HHN_LAST = ...
HHN_NAVCOMPLETE = ...
HHN_TRACK = ...
HHN_WINDOW_CREATE = ...
HHWIN_BUTTON_BACK = ...
HHWIN_BUTTON_BROWSE_BCK = ...
HHWIN_BUTTON_BROWSE_FWD = ...
HHWIN_BUTTON_CONTENTS = ...
HHWIN_BUTTON_EXPAND = ...
HHWIN_BUTTON_FAVORITES = ...
HHWIN_BUTTON_FORWARD = ...
HHWIN_BUTTON_HISTORY = ...
HHWIN_BUTTON_HOME = ...
HHWIN_BUTTON_INDEX = ...
HHWIN_BUTTON_JUMP1 = ...
HHWIN_BUTTON_JUMP2 = ...
HHWIN_BUTTON_NOTES = ...
HHWIN_BUTTON_OPTIONS = ...
HHWIN_BUTTON_PRINT = ...
HHWIN_BUTTON_REFRESH = ...
HHWIN_BUTTON_SEARCH = ...
HHWIN_BUTTON_STOP = ...
HHWIN_BUTTON_SYNC = ...
HHWIN_BUTTON_TOC_NEXT = ...
HHWIN_BUTTON_TOC_PREV = ...
HHWIN_BUTTON_ZOOM = ...
HHWIN_DEF_BUTTONS = ...
HHWIN_NAVTAB_BOTTOM = ...
HHWIN_NAVTAB_LEFT = ...
HHWIN_NAVTAB_TOP = ...
HHWIN_PARAM_CUR_TAB = ...
HHWIN_PARAM_EXPANSION = ...
HHWIN_PARAM_EXSTYLES = ...
HHWIN_PARAM_HISTORY_COUNT = ...
HHWIN_PARAM_INFOTYPES = ...
HHWIN_PARAM_NAV_WIDTH = ...
HHWIN_PARAM_PROPERTIES = ...
HHWIN_PARAM_RECT = ...
HHWIN_PARAM_SHOWSTATE = ...
HHWIN_PARAM_STYLES = ...
HHWIN_PARAM_TABORDER = ...
HHWIN_PARAM_TABPOS = ...
HHWIN_PARAM_TB_FLAGS = ...
HHWIN_PROP_AUTO_SYNC = ...
HHWIN_PROP_CHANGE_TITLE = ...
HHWIN_PROP_MENU = ...
HHWIN_PROP_NAV_ONLY_WIN = ...
HHWIN_PROP_NO_TOOLBAR = ...
HHWIN_PROP_NODEF_EXSTYLES = ...
HHWIN_PROP_NODEF_STYLES = ...
HHWIN_PROP_NOTB_TEXT = ...
HHWIN_PROP_NOTITLEBAR = ...
HHWIN_PROP_ONTOP = ...
HHWIN_PROP_POST_QUIT = ...
HHWIN_PROP_TAB_ADVSEARCH = ...
HHWIN_PROP_TAB_AUTOHIDESHOW = ...
HHWIN_PROP_TAB_CUSTOM1 = ...
HHWIN_PROP_TAB_CUSTOM2 = ...
HHWIN_PROP_TAB_CUSTOM3 = ...
HHWIN_PROP_TAB_CUSTOM4 = ...
HHWIN_PROP_TAB_CUSTOM5 = ...
HHWIN_PROP_TAB_CUSTOM6 = ...
HHWIN_PROP_TAB_CUSTOM7 = ...
HHWIN_PROP_TAB_CUSTOM8 = ...
HHWIN_PROP_TAB_CUSTOM9 = ...
HHWIN_PROP_TAB_FAVORITES = ...
HHWIN_PROP_TAB_HISTORY = ...
HHWIN_PROP_TAB_SEARCH = ...
HHWIN_PROP_TRACKING = ...
HHWIN_PROP_TRI_PANE = ...
HHWIN_PROP_USER_POS = ...
HHWIN_TB_MARGIN = ...
IDTB_BACK = ...
IDTB_BROWSE_BACK = ...
IDTB_BROWSE_FWD = ...
IDTB_CONTENTS = ...
IDTB_CONTRACT = ...
IDTB_CUSTOMIZE = ...
IDTB_EXPAND = ...
IDTB_FAVORITES = ...
IDTB_FORWARD = ...
IDTB_HISTORY = ...
IDTB_HOME = ...
IDTB_INDEX = ...
IDTB_JUMP1 = ...
IDTB_JUMP2 = ...
IDTB_NOTES = ...
IDTB_OPTIONS = ...
IDTB_PRINT = ...
IDTB_REFRESH = ...
IDTB_SEARCH = ...
IDTB_STOP = ...
IDTB_SYNC = ...
IDTB_TOC_NEXT = ...
IDTB_TOC_PREV = ...
IDTB_ZOOM = ...