# Generated by Django 3.2.8 on 2021-11-08 06:06

import uuid

from django.db import migrations, models


def create_uuid(apps, schema_editor):
    Example = apps.get_model("api", "example")
    for example in Example.objects.all():
        example.uuid = uuid.uuid4()
        example.save(update_fields=["uuid"])


class Migration(migrations.Migration):

    dependencies = [
        ("api", "0016_auto_20211018_0556"),
    ]

    operations = [
        migrations.AddField(
            model_name="example",
            name="uuid",
            field=models.UUIDField(editable=False, blank=True, null=True),
        ),
        migrations.RunPython(create_uuid, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name="example", name="uuid", field=models.UUIDField(default=uuid.uuid4, db_index=True, unique=True)
        ),
    ]
