"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../lib");
/// !show
// Pick the right Amazon Linux edition. All arguments shown are optional
// and will default to these values when omitted.
const amznLinux = ec2.MachineImage.latestAmazonLinux({
    generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
    edition: ec2.AmazonLinuxEdition.STANDARD,
    virtualization: ec2.AmazonLinuxVirt.HVM,
    storage: ec2.AmazonLinuxStorage.GENERAL_PURPOSE,
    cpuType: ec2.AmazonLinuxCpuType.X86_64,
});
// Pick a Windows edition to use
const windows = ec2.MachineImage.latestWindows(ec2.WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
// Read AMI id from SSM parameter store
const ssm = ec2.MachineImage.fromSSMParameter('/my/ami', ec2.OperatingSystemType.LINUX);
// Look up the most recent image matching a set of AMI filters.
// In this case, look up the NAT instance AMI, by using a wildcard
// in the 'name' field:
const natAmi = ec2.MachineImage.lookup({
    name: 'amzn-ami-vpc-nat-*',
    owners: ['amazon'],
});
// For other custom (Linux) images, instantiate a `GenericLinuxImage` with
// a map giving the AMI to in for each region:
const linux = ec2.MachineImage.genericLinux({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
// For other custom (Windows) images, instantiate a `GenericWindowsImage` with
// a map giving the AMI to in for each region:
const genericWindows = ec2.MachineImage.genericWindows({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
/// !hide
Array.isArray(windows);
Array.isArray(amznLinux);
Array.isArray(linux);
Array.isArray(ssm);
Array.isArray(genericWindows);
Array.isArray(natAmi);
//# sourceMappingURL=data:application/json;base64,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