"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 * @experimental
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired !== undefined ? props.acceptanceRequired : true;
        this.whitelistedPrincipals = props.whitelistedPrincipals !== undefined ? props.whitelistedPrincipals : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ? (_a = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _a !== void 0 ? _a : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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