"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SearchBusinessesSortBy(str, Enum):
    r"""The criteria to sort the results (e.g., \"recommended\", \"highest_rated\", etc.)"""

    RECOMMENDED = "recommended"
    HIGHEST_RATED = "highest_rated"
    REVIEW_COUNT = "review_count"


class SearchBusinessesRequestBodyTypedDict(TypedDict):
    query: str
    r"""The search term to find businesses"""
    location: str
    r"""The location to search for businesses"""
    sort_by: NotRequired[SearchBusinessesSortBy]
    r"""The criteria to sort the results (e.g., \"recommended\", \"highest_rated\", etc.)"""
    start: NotRequired[int]
    r"""The starting index for pagination (default is 0)"""
    count: NotRequired[int]
    r"""The number of businesses to retrieve"""


class SearchBusinessesRequestBody(BaseModel):
    query: str
    r"""The search term to find businesses"""

    location: str
    r"""The location to search for businesses"""

    sort_by: Optional[SearchBusinessesSortBy] = None
    r"""The criteria to sort the results (e.g., \"recommended\", \"highest_rated\", etc.)"""

    start: Optional[int] = None
    r"""The starting index for pagination (default is 0)"""

    count: Optional[int] = None
    r"""The number of businesses to retrieve"""


class BusinessesTypedDict(TypedDict):
    business_id: NotRequired[str]
    r"""Unique identifier for the business"""
    alias: NotRequired[str]
    r"""A unique identifier used in the URL for the business"""


class Businesses(BaseModel):
    business_id: Optional[str] = None
    r"""Unique identifier for the business"""

    alias: Optional[str] = None
    r"""A unique identifier used in the URL for the business"""


class SearchBusinessesResponseBodyTypedDict(TypedDict):
    r"""SearchBusinesses API successful response"""

    businesses: NotRequired[List[BusinessesTypedDict]]


class SearchBusinessesResponseBody(BaseModel):
    r"""SearchBusinesses API successful response"""

    businesses: Optional[List[Businesses]] = None
