"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from exfunc.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class RequestTypedDict(TypedDict):
    url: NotRequired[str]
    r"""The URL to start navigating from"""
    objective: NotRequired[str]
    r"""The natural language objective of the navigation"""


class Request(BaseModel):
    url: Optional[str] = None
    r"""The URL to start navigating from"""

    objective: Optional[str] = None
    r"""The natural language objective of the navigation"""


class ResponseTypedDict(TypedDict):
    html: NotRequired[str]
    r"""The HTML string of the page that the navigator reached"""
    img: NotRequired[str]
    r"""The base64-encoded string for screenshot of the page that the navigator reached"""
    markdown: NotRequired[str]
    r"""The markdown string of the page that the navigator reached"""


class Response(BaseModel):
    html: Optional[str] = None
    r"""The HTML string of the page that the navigator reached"""

    img: Optional[str] = None
    r"""The base64-encoded string for screenshot of the page that the navigator reached"""

    markdown: Optional[str] = None
    r"""The markdown string of the page that the navigator reached"""


class Status(str, Enum):
    r"""The status of the navigator task"""

    PENDING = "PENDING"
    IN_PROGRESS = "IN_PROGRESS"
    SUCCEEDED = "SUCCEEDED"
    FAILED = "FAILED"
    TIMED_OUT = "TIMED_OUT"


class NavigatorTaskTypedDict(TypedDict):
    task_id: NotRequired[str]
    r"""The ID of the navigator task"""
    request: NotRequired[RequestTypedDict]
    response: NotRequired[ResponseTypedDict]
    status: NotRequired[Status]
    r"""The status of the navigator task"""
    start_time: NotRequired[str]
    r"""The start time of the navigator task"""
    end_time: NotRequired[str]
    r"""The end time of the navigator task"""
    last_updated_time: NotRequired[str]
    r"""The last updated time of the navigator task"""


class NavigatorTask(BaseModel):
    task_id: Optional[str] = None
    r"""The ID of the navigator task"""

    request: Optional[Request] = None

    response: Optional[Response] = None

    status: Optional[Status] = None
    r"""The status of the navigator task"""

    start_time: Optional[str] = None
    r"""The start time of the navigator task"""

    end_time: Optional[str] = None
    r"""The end time of the navigator task"""

    last_updated_time: Optional[str] = None
    r"""The last updated time of the navigator task"""
