"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ExperiencesTypedDict(TypedDict):
    title: NotRequired[Nullable[str]]
    company_name: NotRequired[str]
    start_date: NotRequired[Nullable[str]]
    end_date: NotRequired[Nullable[str]]


class Experiences(BaseModel):
    title: OptionalNullable[str] = UNSET

    company_name: Optional[str] = None

    start_date: OptionalNullable[str] = UNSET

    end_date: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["title", "company_name", "start_date", "end_date"]
        nullable_fields = ["title", "start_date", "end_date"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LinkedInPersonTypedDict(TypedDict):
    url: NotRequired[str]
    r"""URL to the person's profile"""
    name: NotRequired[str]
    r"""Full name of the person"""
    location: NotRequired[str]
    r"""Location of the person"""
    title: NotRequired[Nullable[str]]
    r"""Job title of the person"""
    company_name: NotRequired[str]
    r"""Name of the company the person works for"""
    company_url: NotRequired[str]
    r"""URL to the company profile"""
    experiences: NotRequired[List[ExperiencesTypedDict]]
    r"""List of experiences or previous job roles of the person"""


class LinkedInPerson(BaseModel):
    url: Optional[str] = None
    r"""URL to the person's profile"""

    name: Optional[str] = None
    r"""Full name of the person"""

    location: Optional[str] = None
    r"""Location of the person"""

    title: OptionalNullable[str] = UNSET
    r"""Job title of the person"""

    company_name: Optional[str] = None
    r"""Name of the company the person works for"""

    company_url: Optional[str] = None
    r"""URL to the company profile"""

    experiences: Optional[List[Experiences]] = None
    r"""List of experiences or previous job roles of the person"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "url",
            "name",
            "location",
            "title",
            "company_name",
            "company_url",
            "experiences",
        ]
        nullable_fields = ["title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
