"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class GoogleProductTypedDict(TypedDict):
    product_id: NotRequired[str]
    r"""The unique identifier for the product"""
    title: NotRequired[str]
    r"""The title of the product"""
    description: NotRequired[Nullable[str]]
    r"""A detailed description of the product"""
    photos: NotRequired[List[str]]
    r"""An array of URLs for the product photos"""
    attributes: NotRequired[Nullable[Dict[str, str]]]
    r"""A set of attributes for the product, represented as key-value pairs"""
    rating: NotRequired[Nullable[float]]
    r"""The average rating of the product"""
    page_url: NotRequired[str]
    r"""The URL link to the product page"""
    num_reviews: NotRequired[Nullable[int]]
    r"""The total number of reviews for the product"""
    reviews_per_rating: NotRequired[Dict[str, int]]
    r"""The number of reviews for each rating level"""
    product_details: NotRequired[Dict[str, str]]
    r"""Detailed information about the product"""
    product_specs: NotRequired[Dict[str, str]]
    r"""Technical specifications of the product"""


class GoogleProduct(BaseModel):
    product_id: Optional[str] = None
    r"""The unique identifier for the product"""

    title: Optional[str] = None
    r"""The title of the product"""

    description: OptionalNullable[str] = UNSET
    r"""A detailed description of the product"""

    photos: Optional[List[str]] = None
    r"""An array of URLs for the product photos"""

    attributes: OptionalNullable[Dict[str, str]] = UNSET
    r"""A set of attributes for the product, represented as key-value pairs"""

    rating: OptionalNullable[float] = UNSET
    r"""The average rating of the product"""

    page_url: Optional[str] = None
    r"""The URL link to the product page"""

    num_reviews: OptionalNullable[int] = UNSET
    r"""The total number of reviews for the product"""

    reviews_per_rating: Optional[Dict[str, int]] = None
    r"""The number of reviews for each rating level"""

    product_details: Optional[Dict[str, str]] = None
    r"""Detailed information about the product"""

    product_specs: Optional[Dict[str, str]] = None
    r"""Technical specifications of the product"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "product_id",
            "title",
            "description",
            "photos",
            "attributes",
            "rating",
            "page_url",
            "num_reviews",
            "reviews_per_rating",
            "product_details",
            "product_specs",
        ]
        nullable_fields = ["description", "attributes", "rating", "num_reviews"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
