# Paging Mission Control

> You are tasked with assisting satellite ground operations for an earth science mission that monitors magnetic field variations at the Earth's poles. A pair of satellites fly in tandem orbit such that at least one will have line of sight with a pole to take accurate readings. The satellite’s science instruments are sensitive to changes in temperature and must be monitored closely. Onboard thermostats take several temperature readings every minute to ensure that the precision magnetometers do not overheat. Battery systems voltage levels are also monitored to ensure that power is available to cooling coils. Design a monitoring and alert application that processes status telemetry from the satellites and generates alert messages in cases of certain limit violation scenarios.

## Requirements

Ingest status telemetry data and create alert messages for the following violation conditions:

- If for the same satellite there are three battery voltage readings that are under the red low limit within a five minute interval.
- If for the same satellite there are three thermostat readings that exceed the red high limit within a five minute interval.

### Input Format

The program is to accept a file as input. The file is an ASCII text file containing pipe delimited records.

The ingest of status telemetry data has the format:

```plaintext
<timestamp>|<satellite-id>|<red-high-limit>|<yellow-high-limit>|<yellow-low-limit>|<red-low-limit>|<raw-value>|<component>
```

You may assume that the input files are correctly formatted. Error handling for invalid input files may be ommitted.

### Output Format

The output will specify alert messages.  The alert messages should be valid JSON with the following properties:

```javascript
{
    "satelliteId": 1234,
    "severity": "severity",
    "component": "component",
    "timestamp": "timestamp"
}
```

The program will output to screen or console (and not to a file).

## Sample Data

The following may be used as sample input and output datasets.

### Input

```plaintext
20180101 23:01:05.001|1001|101|98|25|20|99.9|TSTAT
20180101 23:01:09.521|1000|17|15|9|8|7.8|BATT
20180101 23:01:26.011|1001|101|98|25|20|99.8|TSTAT
20180101 23:01:38.001|1000|101|98|25|20|102.9|TSTAT
20180101 23:01:49.021|1000|101|98|25|20|87.9|TSTAT
20180101 23:02:09.014|1001|101|98|25|20|89.3|TSTAT
20180101 23:02:10.021|1001|101|98|25|20|89.4|TSTAT
20180101 23:02:11.302|1000|17|15|9|8|7.7|BATT
20180101 23:03:03.008|1000|101|98|25|20|102.7|TSTAT
20180101 23:03:05.009|1000|101|98|25|20|101.2|TSTAT
20180101 23:04:06.017|1001|101|98|25|20|89.9|TSTAT
20180101 23:04:11.531|1000|17|15|9|8|7.9|BATT
20180101 23:05:05.021|1001|101|98|25|20|89.9|TSTAT
20180101 23:05:07.421|1001|17|15|9|8|7.9|BATT
```

### Ouput

```javascript
[
    {
        "satelliteId": 1000,
        "severity": "RED HIGH",
        "component": "TSTAT",
        "timestamp": "2018-01-01T23:01:38.001Z"
    },
    {
        "satelliteId": 1000,
        "severity": "RED LOW",
        "component": "BATT",
        "timestamp": "2018-01-01T23:01:09.521Z"
    }
]
```

### Assumptions

These assumptions are not all covered by the spec as far as I understand it. I tried to reach out through my contacts to get answers to these questions but was told to use my best judgment.

- output order sorted by timestamp desc
- assuming file will always be readable (permissions)
- no newline at the end of the input ASCII text file
- file name will not exceed python file name length limitations
- files are not too big (file not too big to fit in memory)
- input file rows are always in chronological order
- input has reasonable values (battery is not going under 0 or over 100, themostat is not going to be hotter than the sun etc. basically no numbers that would overflow)
- interval is within 5-minutes which does not include 5-minute mark i.e. `23:00:00.000-23:04:59.999` but would not include a limit-breaking entry at `23:05:00.000`
- alerts are once per id/component/type per file; i.e. if there are multiple bursts of limit-breaking entries of the same type for a single component on the same satellite, then only ONE alert is shown

### Running The App

```bash

python -m mission_control <FILENAME>

```

### Running Tests

```bash

python -m unittest

```

### Formatting

```bash

black .

```

### Type-Checking/Linting

```bash

mypy mission_control tests

```

### Packaging

Uploading to `testpypi` since it's not a real package

```bash

python -m pip install --upgrade setuptools wheel

python setup.py sdist bdist_wheel

python -m pip install --upgrade twine

python -m twine upload --repository testpypi --skip-existing dist/*

```

### Using Package

```bash

python -m pip install --index-url https://test.pypi.org/simple/ --no-deps mission_control

```

### If this were a real project some additions

- use tox to verify that the package works with multiple environments
- add sphinx for docs
- use pytest and get proper coverage reports
