# aind-smartsheet-service-client

## aind-smartsheet-service

Service to pull data from SmartSheet.



This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.3
- Package version: 0.1.3
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import aind_smartsheet_service_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import aind_smartsheet_service_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import aind_smartsheet_service_client
from aind_smartsheet_service_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = aind_smartsheet_service_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with aind_smartsheet_service_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = aind_smartsheet_service_client.DefaultApi(api_client)
    project_name = 'Discovery-Neuromodulator circuit dynamics during foraging' # str |  (optional)
    subproject = 'Subproject 2 Molecular Anatomy Cell Types' # str |  (optional)

    try:
        # Get Funding
        api_response = api_instance.get_funding(project_name=project_name, subproject=subproject)
        print("The response of DefaultApi->get_funding:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_funding: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_funding**](docs/DefaultApi.md#get_funding) | **GET** /funding | Get Funding
*DefaultApi* | [**get_perfusions**](docs/DefaultApi.md#get_perfusions) | **GET** /perfusions | Get Perfusions
*DefaultApi* | [**get_project_names**](docs/DefaultApi.md#get_project_names) | **GET** /project_names | Get Project Names
*DefaultApi* | [**get_protocols**](docs/DefaultApi.md#get_protocols) | **GET** /protocols | Get Protocols
*HealthcheckApi* | [**get_health**](docs/HealthcheckApi.md#get_health) | **GET** /healthcheck | Perform a Health Check


## Documentation For Models

 - [FundingModel](docs/FundingModel.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [PerfusionsModel](docs/PerfusionsModel.md)
 - [ProtocolsModel](docs/ProtocolsModel.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




