# This is the client library generated by this plugin.
from oceanbolt.com import tonnage, portcalls, drydock, congestion, tradeflows, entities
from google.auth import credentials, _helpers  # type: ignore
import os


class ObCredentials(credentials.Credentials):
    @property
    def expired(self):
        """Returns `False`, OB credentials never expire."""
        return False

    @property
    def valid(self):
        """Returns `True`, OB credentials are always valid."""
        return True

    def refresh(self, request):
        """Raises :class:`ValueError``, anonymous credentials cannot be
        refreshed."""
        raise ValueError("OB credentials cannot be refreshed.")

    def apply(self, headers, token=None):
        """Sets the token in the header."""
        headers["authorization"] = "Bearer {}".format(
            _helpers.from_bytes(token or self.token)
        )

    def before_request(self, request, method, url, headers):
        """OB credentials applies headers to the request."""
        self.apply(headers)


class APIClient:

    def __init__(self, token=None):
        api_key = os.getenv("OCEANBOLT_API_KEY")
        if api_key is None and token is None:
            raise KeyError(
                "You must either set the OCEANBOLT_API_KEY environment variable, or supply enter your Oceanbolt API key as a string argument."
                " You can create API keys at https://app.oceanbolt.com"
            )

        creds = ObCredentials()

        if token is not None:
            creds.token = token
        else:
            creds.token = api_key


        self.tonnageClient = tonnage.TonnageServiceClient(credentials=creds)
        self.portCallsClient = portcalls.PortCallServiceClient(credentials=creds)
        self.tradeFlowsClient = tradeflows.TradeFlowServiceClient(credentials=creds)
        self.congestionClient = congestion.CongestionServiceClient(credentials=creds)
        self.drydockClient = drydock.DrydockServiceClient(credentials=creds)
        self.entitiesClient = entities.EntityServiceClient(credentials=creds)

    def _tonnage_client(self):
        return self.tonnageClient

    def _congestion_client(self):
        return self.congestionClient

    def _tradeflows_client(self):
        return self.tradeFlowsClient

    def _drydock_client(self):
        return self.drydockClient

    def _portcalls_client(self):
        return self.portCallsClient

    def _entities_client(self):
        return self.entitiesClient
