"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DAXMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DAXMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static itemCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheHits',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static itemCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheMisses',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static batchGetItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchGetItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static batchWriteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchWriteItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static cacheMemoryUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CacheMemoryUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static clientConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ClientConnections',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deleteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'DeleteItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static errorRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ErrorRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static estimatedDbSizeAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EstimatedDbSize',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static evictedSizeSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EvictedSize',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static failedRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FailedRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static faultRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FaultRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static getItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'GetItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesIn',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesOut',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsIn',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsOut',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static putItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'PutItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheHits',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheMisses',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queryRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheHits',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheMisses',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static scanRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static throttledRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ThrottledRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static totalRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TotalRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static transactGetItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactGetItemsCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static transactWriteItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactWriteItemsCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static updateItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'UpdateItemRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DAXMetrics = DAXMetrics;
//# sourceMappingURL=data:application/json;base64,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