# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['blackt']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'click>=7.1.2,<8.0.0',
 'mypy-extensions>=0.4.3,<0.5.0',
 'pathspec>=0.8.1,<0.9.0',
 'regex>=2021.4.4,<2022.0.0',
 'toml>=0.10.2,<0.11.0',
 'typed-ast>=1.4.2,<2.0.0',
 'typing-extensions>=3.7.4,<4.0.0']

entry_points = \
{'console_scripts': ['blackt = blackt:patched_main']}

setup_kwargs = {
    'name': 'blackt',
    'version': '2021a1',
    'description': '',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/AnsiToImg.svg?style=for-the-badge)](https://pypistats.org/packages/ansitoimg)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2FAnsiToImg)](https://pepy.tech/project/AnsiToImg)\n[![PyPI Version](https://img.shields.io/pypi/v/AnsiToImg.svg?style=for-the-badge)](https://pypi.org/project/AnsiToImg)\n\n<!-- omit in toc -->\n# AnsiToImg\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nConvert an ANSI string to an image. Great for adding terminal output into a readme.\n\n- [Examples](#examples)\n\t- [SVG Image](#svg-image)\n\t- [Raster Image](#raster-image)\n\t- [SVGRaster Image](#svgraster-image)\n\t- [HTML/ HTMLRaster Image](#html-htmlraster-image)\n\t- [Windows Terminal](#windows-terminal)\n- [Choosing ansiToSVG, ansiToRaster, ansiToSVGRaster, ansiToHTML or ansiToHTMLRaster](#choosing-ansitosvg-ansitoraster-ansitosvgraster-ansitohtml-or-ansitohtmlraster)\n\t- [ansiToSVG](#ansitosvg)\n\t- [ansiToRaster](#ansitoraster)\n\t- [ansiToSVGRaster](#ansitosvgraster)\n\t- [ansiToHTML](#ansitohtml)\n\t- [ansiToHTMLRaster](#ansitohtmlraster)\n- [Docs](#docs)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Examples\n\nHere is an example of some code and the images it produces:\n\nFunctions accept the following arguments:\n- ansiText - text to process\n- fileName - name of the file to write to\n- theme - a base24 theme. Defaults to atom one dark\n\n```python\nimport sys\nimport os\nfrom pathlib import Path\nimport platform\nimport ctypes\nfrom catimage.catimage import generateHDColour\n\nTHISDIR = str(Path(__file__).resolve().parent)\nsys.path.insert(0, os.path.dirname(THISDIR))\nfrom ansitoimg.render import ansiToSVG, ansiToRaster, ansiToSVGRaster, ansiToHTML, ansiToHTMLRaster\n\n\nif platform.system() == "Windows":\n\tkernel32 = ctypes.windll.kernel32\n\tkernel32.SetConsoleMode(kernel32.GetStdHandle(-11), 7)\n\n# Define ANSI text\nexample = "👋\\033[32mHello\\033[0m, \\033[34mWorld\\033[0m🌏\\033[31m!\\033[0m\\n\\033[41m👋\\033[0m\\033[43m🦄\\033[0m\\033[42m🐘\\033[0m\\033[3m\\033[9m13\\033[0m\\033[1m3\\033[0m\\033[4m7\\033[0m\\033[46m🍄\\033[0m\\033[44m🎃\\033[0m\\033[45m🐦\\033[0m"\nexample2 = "hello\\nworld\\n\\033[42m\\033[31mwe meet again\\033[0m\\nABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz😁😂🤣😃😄😅😆😉😊😋😎😍😘🥰😗😙😚☺🙂🤗🤩🤔🤨😐😑😶🙄😏😣😥😮🤐😯😪asdfghjk"\nexample3 = generateHDColour(THISDIR + "/test.png", 40)\n\n# Print\nprint(example)\nprint()\nprint(example2)\nprint()\nprint(example3)\nprint()\n\n# To SVG\nansiToSVG(example, THISDIR + "/example.svg")\nansiToSVG(example2, THISDIR + "/example2.svg")\nansiToSVG(example3, THISDIR + "/example3.svg")\n\n# To Raster\nansiToRaster(example, THISDIR + "/example.png")\nansiToRaster(example2, THISDIR + "/example2.png")\nansiToRaster(example3, THISDIR + "/example3.png")\n\n# To SVGRaster\nansiToSVGRaster(example, THISDIR + "/svgExample.png")\nansiToSVGRaster(example2, THISDIR + "/svgExample2.png")\nansiToSVGRaster(example3, THISDIR + "/svgExample3.png")\n\n# To HTML\nansiToHTML(example, THISDIR + "/example.html")\nansiToHTML(example2, THISDIR + "/example2.html")\nansiToHTML(example3, THISDIR + "/example3.html")\n\n# To HTMLRaster\nansiToHTMLRaster(example, THISDIR + "/htmlExample.png")\nansiToHTMLRaster(example2, THISDIR + "/htmlExample2.png")\nansiToHTMLRaster(example3, THISDIR + "/htmlExample3.png")\n```\n\n### SVG Image\n![example](test/example.svg)\n\n![example2](test/example2.svg)\n\n![example3](test/example3.svg)\n\n### Raster Image\n![example](test/example.png)\n\n![example2](test/example2.png)\n\n![example3](test/example3.png)\n\n### SVGRaster Image\n![example](test/svgExample.png)\n\n![example2](test/svgExample2.png)\n\n![example3](test/svgExample3.png)\n\n### HTML/ HTMLRaster Image\n![example](test/htmlExample.png)\n\n![example2](test/htmlExample2.png)\n\n![example3](test/htmlExample3.png)\n\n\n### Windows Terminal\n\n<img src="readme-assets/terminal.png" alt="winterm" width="450">\n\n## Choosing ansiToSVG, ansiToRaster, ansiToSVGRaster, ansiToHTML or ansiToHTMLRaster\n\n### ansiToSVG\nThis is better for the vast majority of cases as the image sizes are smaller\nfor reasonably simple ANSI sequences. The image size scales proportionally\nwith the length of the ANSI sequence. A large number of applications tend to\nopt for shorter sequences for output making `ansiToSVG` the better option.\n`ansiToSVG` also handles emoji as well as the OS does. For instance, on Windows\n10 one can expect full colour emoji. Image sizes can get out of hand for some\ncases such as catimage output as those tend to be very long ANSI sequences.\n\n### ansiToRaster\nThe image size does not scale to the length of the ANSI sequence but does scale\nto the number of lines of terminal output. This is ideal for output of complex\nANSI sequences that would be huge if `ansiToSVG` were used. However, emojis are\nin black and white and show quite poorly on coloured backgrounds.\n\n### ansiToSVGRaster\nTakes the advantages that `ansiToRaster` has whilst keeping colour emojis, Yay!\nThis uses pyppeteer to fire up a headless browser which opens the SVG and takes\na screenshot.\n\n### ansiToHTML\nHas the same advantages and disadvantages of `ansiToSVG` though this is not\nsuitable to be included in a GitHub readme\n\n### ansiToHTMLRaster\nHas the same advantages and disadvantages of `ansiToSVGRaster`\n\n\n## Docs\nSee the [Docs](/DOCS/) for more information.\n\n\n## Install With PIP\n\n```python\npip install ansitoimg\n```\n\nHead to https://pypi.org/project/ansitoimg/ for more info\n\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.9.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.9\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.9 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.9)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n\n## Download Project\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/AnsiToImg\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/blackt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>3.6',
}


setup(**setup_kwargs)
