from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    IntegerType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Sequence_ReferenceSeqSchema:
    """
    Raw data describing a biological sequence.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Raw data describing a biological sequence.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        chromosome: Structural unit composed of a nucleic acid molecule which controls its own
            replication through the interaction of specific proteins at one or more
            origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/c
            urrent_svn/term/SO:0000340)).

        genomeBuild: The Genome Build used for reference, following GRCh build versions e.g. 'GRCh
            37'.  Version number must be included if a versioned release of a primary
            build was used.

        referenceSeqId: Reference identifier of reference sequence submitted to NCBI. It must match
            the type in the Sequence.type field. For example, the prefix, “NG_” identifies
            reference sequence for genes, “NM_” for messenger RNA transcripts, and “NP_”
            for amino acid sequences.

        referenceSeqPointer: A Pointer to another Sequence entity as reference sequence.

        referenceSeqString: A string like "ACGT".

        strand: Directionality of DNA sequence. Available values are "1" for the plus strand
            (5' to 3')/Watson/Sense/positive  and "-1" for the minus strand(3' to
            5')/Crick/Antisense/negative.

        windowStart: Start position of the window on the reference sequence. If the coordinate
            system is either 0-based or 1-based, then start position is inclusive.

        windowEnd: End position of the window on the reference sequence. If the coordinate system
            is 0-based then end is is exclusive and does not include the last position. If
            the coordinate system is 1-base, then end is inclusive and includes the last
            position.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Sequence_ReferenceSeq") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Sequence_ReferenceSeq"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Structural unit composed of a nucleic acid molecule which controls its own
                # replication through the interaction of specific proteins at one or more
                # origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/c
                # urrent_svn/term/SO:0000340)).
                StructField(
                    "chromosome",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The Genome Build used for reference, following GRCh build versions e.g. 'GRCh
                # 37'.  Version number must be included if a versioned release of a primary
                # build was used.
                StructField("genomeBuild", StringType(), True),
                # Reference identifier of reference sequence submitted to NCBI. It must match
                # the type in the Sequence.type field. For example, the prefix, “NG_” identifies
                # reference sequence for genes, “NM_” for messenger RNA transcripts, and “NP_”
                # for amino acid sequences.
                StructField(
                    "referenceSeqId",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A Pointer to another Sequence entity as reference sequence.
                StructField(
                    "referenceSeqPointer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A string like "ACGT".
                StructField("referenceSeqString", StringType(), True),
                # Directionality of DNA sequence. Available values are "1" for the plus strand
                # (5' to 3')/Watson/Sense/positive  and "-1" for the minus strand(3' to
                # 5')/Crick/Antisense/negative.
                StructField("strand", IntegerType(), True),
                # Start position of the window on the reference sequence. If the coordinate
                # system is either 0-based or 1-based, then start position is inclusive.
                StructField("windowStart", IntegerType(), True),
                # End position of the window on the reference sequence. If the coordinate system
                # is 0-based then end is is exclusive and does not include the last position. If
                # the coordinate system is 1-base, then end is inclusive and includes the last
                # position.
                StructField("windowEnd", IntegerType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
