# ALToolbox

This repository is used to host small Python modules, widgets, and JavaScript web components js files that enhance Docassemble interviews. These modules were
built as part of the Suffolk University Law School LIT Lab's [Document Assembly Line project](https://suffolklitlab.org/docassemble-AssemblyLine-documentation/).
They are placed here
rather than in https://github.com/SuffolkLitLab/docassemble-AssemblyLine because we believe these small components can easily be used
by anyone, regardless of whether they use any other code from the Document Assembly Line project.

If you want to add a small fuction to this project, consider adding it to the existing misc.py to avoid creating too many module files.

## Documentation

Read the [documentation for the functions and components](https://suffolklitlab.org/docassemble-AssemblyLine-documentation/docs/framework/altoolbox) to learn
how to use these components in your own [Docassemble](https://github.com/jhpyle/docassemble) projects.

## Suffolk LIT Lab Document Assembly Line

<img src="https://user-images.githubusercontent.com/7645641/142245862-c2eb02ab-3090-4e97-9653-bb700bf4c54d.png" alt="drawing" width="300" alt="work together" style="align: center;"/>

The Assembly Line Project is a collection of volunteers, students, and institutions who joined together
during the COVID-19 pandemic to help increase access to the court system. Our vision is mobile-friendly,
easy to use **guided** online forms that help empower litigants to access the court remotely.

Our signature project is [CourtFormsOnline.org](https://courtformsonline.org).

We designed a step-by-step, assembly line style process for automating court forms on top of Docassemble
and built several tools along the way that **you** can use in your home jurisdiction.

This package contains **runtime code** and **pre-written questions** to support authoring robust, 
consistent, and attractive Docassemble interviews that help complete court forms.

Read more on our [documentation page](https://suffolklitlab.org/docassemble-AssemblyLine-documentation/).


# Related repositories

* https://github.com/SuffolkLitLab/docassemble-AssemblyLine
* https://github.com/SuffolkLitLab/docassemble-ALWeaver
* https://github.com/SuffolkLitLab/docassemble-ALMassachusetts
* https://github.com/SuffolkLitLab/docassemble-MassAccess
* https://github.com/SuffolkLitLab/docassemble-ALGenericJurisdiction
* https://github.com/SuffolkLitLab/EfileProxyServer

## Contributors:  
* @plocket  
* @nonprofittechy
* @purplesky2016
* @brycestevenwilley
