from typing import Dict, List, Union

from belvo.resources.base import Resource


class InvestmentsPortfolios(Resource):
    """
    <br>
    <div style="background-color:#bce9af;padding: 6px; border-radius: 4px">
      <strong>🎉 In Beta </strong><br>
      This resource is currently in open beta for all users. If you see any issues, don't hesitate to contact our support team. 
      </div>

    """
    endpoint = "/investments/portfolios/"

    def create(
        self,
        link: str,
        *,
        token: str = None,
        save_data: bool = True,
        raise_exception: bool = False,
        **kwargs: Dict,
    ) -> Union[List[Dict], Dict]:
        """Retrieve portfolios for a link

        Example:
            ```python
            # Fetch investments portfolios for a Link
            investments_portfolios = client.InvestmentsPortfolios.create("b91835f5-6f83-4d9b-a0ad-a5a249f18b7c")
            ```

        Args:
            link (str): The `link.id` that you want to get information for (UUID).
            token (str, optional): The MFA token generated by the bank in order to access the institution. Defaults to None.
            save_data (bool, optional): Indicates whether or not to persist the data in Belvo. Defaults to `True`.
            raise_exception (bool, optional): Indicates whether to raise an exception or return the API error. Defaults to `False`.

        Returns:
            Dict: The details of the object. For more information on the response from the API, see our [Investment portfolios API documentation](https://developers.belvo.com/reference/retrieveportfolio).
        """

        data = {"link": link, "save_data": save_data}

        if token:
            data.update(token=token)

        return self.session.post(
            self.endpoint, data=data, raise_exception=raise_exception, **kwargs
        )
