# TelegramTextApp
**TelegramTextApp** — это надстройка над [aiogram](https://github.com/aiogram/aiogram), которая упрощает создание бота в **telegram**



## Установка и настройка

### Требования
- Python 3.10 или новее
- Аккаунт Telegram

### Шаги:
#### Установка библиотеки
```bash
pip install TelegramTextApp
```
#### Первый запуск
При первом запуске, автоматически будут созданы `.env` и `bot.json` файлы, для работы с библиотекой
```python
import TelegramTextApp

if __name__ == "__main__":
    TelegramTextApp.start()
```
## Скоро появится
- [ ] Поддержка `inline` режима
- [ ] Работа с файлами
- [ ] Готовые шаблоны кнопок и меню (Календарь из кнопок, выбор нужных пунктов, работа с @send)

# Минимальная структура бота

## Структура для хранения атрибутов
```json
{
  "bot": {},
  "menu": {},
  "variables": {},
  "commands": {}
}
```

## Создание меню
```json
"название_меню"{
  "text":"str",
  "keyboard":{
    "назавние_меню":"Текст кнопки",
  },
  "return":"название_меню"
}
```

## Создание команды
```json
"название_команды": {
  "description": "описание_команды",
  "menu": "название_меню"
}
```

## Обязательные параметры json
Обязательные параметры изначально указываются при создании `bot.json`
```json
"variables": {
  "tta_return": "‹ Назад",
  "tta_loading":"Загрузка...",
  "tta_pagination_back": "‹",
  "tta_pagination_next": "›"
},
```

## Подробная документация
Для более подробной документации, обратитесть в [Wiki](https://github.com/falbue/TelegramTextApp/wiki)

# Как внести вклад
- Форкните репозиторий
- Создайте ветку с фичей/исправлением:
- Зафиксируйте изменения и отправьте в форк
- Создайте Pull Request с описанием изменений

# 📬 Обратная связь
- **Автор:** [falbue](https://github.com/falbue)
- **Баги и предложения:** [Issues](https://github.com/falpin/TelegramTextApp/issues)
